<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  version="1.0">

  <xsl:output method="text" encoding="utf-8"/>

  <xsl:template match="/">
    <xsl:text>

[iimsensor]

# device address
dev = 0
speed = 10000000

ilff = 1

</xsl:text>

    <xsl:apply-templates select="x:settings"/>

  </xsl:template>

  <xsl:template match="text()"/>

  <xsl:template match="x:measurement-program/x:alternatives/x:current">
    <xsl:text>main = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="x:sample-rate/x:value">
    <xsl:text>odr = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
    <xsl:text>accel_odr = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
    <xsl:text>gyro_odr = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="x:packet-decimation">
    <xsl:text>fdr_sel = </xsl:text>
    <xsl:value-of select="x:value"/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

<!--
  <xsl:template match="x:axes/x:invert">
    <xsl:text>accel_factor_</xsl:text>
    <xsl:value-of select="x:axis"/>
    <xsl:text> = </xsl:text>
    <xsl:choose>
      <xsl:when test="number(x:enable)">-1</xsl:when>
      <xsl:otherwise>1</xsl:otherwise>
    </xsl:choose>
    <xsl:text>&#xa;</xsl:text>
    <xsl:text>gyro_factor_</xsl:text>
    <xsl:value-of select="x:axis"/>
    <xsl:text> = </xsl:text>
    <xsl:choose>
      <xsl:when test="number(x:enable)">-1</xsl:when>
      <xsl:otherwise>1</xsl:otherwise>
    </xsl:choose>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>
-->

  <xsl:template match="x:sensors">
    <xsl:choose>
      <xsl:when test="number(x:accel/x:enable) and number(x:gyro/x:enable) and number(../x:full-precision)">
	<xsl:text>fifo_packet = 4</xsl:text>
      </xsl:when>
      <xsl:when test="number(x:accel/x:enable) and number(x:gyro/x:enable)">
	<xsl:text>fifo_packet = 3</xsl:text>
      </xsl:when>
      <xsl:when test="number(x:gyro/x:enable)">
	<xsl:text>fifo_packet = 2</xsl:text>
      </xsl:when>
      <xsl:when test="number(x:accel/x:enable)">
	<xsl:text>fifo_packet = 1</xsl:text>
      </xsl:when>
    </xsl:choose>
    <xsl:text>&#xa;</xsl:text>
    <xsl:text>temp_ext_enable = [</xsl:text>
    <xsl:for-each select="x:temp[@index > 0][x:enable = 1]">
      <xsl:if test="position()>1">
	<xsl:text>,</xsl:text>
      </xsl:if>
      <xsl:value-of select="@index -1"/>
    </xsl:for-each>
    <xsl:text>]&#xa;</xsl:text>
    <xsl:apply-templates/>
  </xsl:template>
  
  <xsl:template match="x:sensors/x:accel/x:range">
    <xsl:text>accel_full_scale = </xsl:text>
    <xsl:value-of select="x:value"/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>
  <xsl:template match="x:sensors/x:gyro/x:range">
    <xsl:text>gyro_full_scale = </xsl:text>
    <xsl:value-of select="x:value"/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="x:sensors/x:accel/x:unit">
    <xsl:text>accel_g = </xsl:text>
    <xsl:choose>
      <xsl:when test="x:value = 'g'">1</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>
<!--
  <xsl:template match="x:sensors/x:accel/x:enable">
    <xsl:text>powerAccel = </xsl:text>
    <xsl:choose>
      <xsl:when test=". = 0">off</xsl:when>
      <xsl:otherwise>lownoise</xsl:otherwise>
    </xsl:choose>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>
  <xsl:template match="x:sensors/x:gyro/x:enable">
    <xsl:text>powerGyro = </xsl:text>
    <xsl:choose>
      <xsl:when test=". = 0">off</xsl:when>
      <xsl:otherwise>lownoise</xsl:otherwise>
    </xsl:choose>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template> -->

  <xsl:template match="x:sensors/x:gyro/x:notch-filter/x:enable">
    <xsl:text>gyro_nfilter_disable = </xsl:text>
    <xsl:value-of select="number(not(number(.)))"/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>
  <xsl:template match="x:sensors/x:gyro/x:notch-filter/x:bandwidth">
    <xsl:if test="number(x:value)">
      <xsl:text>gyro_nfilter_bw = </xsl:text>
      <xsl:value-of select="x:value"/>
      <xsl:text>&#xa;</xsl:text>
    </xsl:if>
  </xsl:template>
  <xsl:template match="x:sensors/x:gyro/x:notch-filter/x:center">
    <xsl:if test="number(x:value)">
      <xsl:text>gyro_nfilter_center_</xsl:text>
      <xsl:value-of select="x:axis"/>
      <xsl:text> = </xsl:text>
      <xsl:value-of select="x:value"/>
      <xsl:text>&#xa;</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="x:sensors/x:accel/x:aa-filter/x:enable">
    <xsl:text>accel_aafilter_disable = </xsl:text>
    <xsl:value-of select="number(not(number(.)))"/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>
  <xsl:template match="x:sensors/x:accel/x:aa-filter/x:bandwidth">
    <xsl:text>accel_aafilter_bw = </xsl:text>
    <xsl:value-of select="x:value"/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>
  <xsl:template match="x:sensors/x:gyro/x:aa-filter/x:enable">
    <xsl:text>gyro_aafilter_disable = </xsl:text>
    <xsl:value-of select="number(not(number(.)))"/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>
  <xsl:template match="x:sensors/x:gyro/x:aa-filter/x:bandwidth">
    <xsl:text>gyro_aafilter_bw = </xsl:text>
    <xsl:value-of select="x:value"/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>
  
  <xsl:template match="x:sensors/x:accel/x:offset">
    <xsl:if test="string-length(x:value)">
      <xsl:text>accel_offset_</xsl:text>
      <xsl:value-of select="x:axis"/>
      <xsl:text> = </xsl:text>
      <xsl:value-of select="x:value"/>
      <xsl:text>&#xa;</xsl:text>
    </xsl:if>
  </xsl:template>
  <xsl:template match="x:sensors/x:gyro/x:offset">
    <xsl:if test="string-length(x:value)">
      <xsl:text>gyro_offset_</xsl:text>
      <xsl:value-of select="x:axis"/>
      <xsl:text> = </xsl:text>
      <xsl:value-of select="x:value"/>
      <xsl:text>&#xa;</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="x:*" mode="filtbw-to-num" name="filtbw-to-num">
    <xsl:param name="str" select="."/>
    <xsl:variable name="divi" select="substring-after($str, '/')"/>
    <xsl:value-of select="/*/x:sample-rate/x:value div $divi"/>
  </xsl:template>
  
  <xsl:template match="x:sensors/x:accel/x:filter/x:bandwidth">
    <xsl:text>accel_uifilter_bw_int = </xsl:text>
    <!--    <xsl:apply-templates select="x:value" mode="filtbw-to-num"/> -->
    <xsl:variable name="offset">
      <xsl:choose>
	<xsl:when test="../x:low-latency = 0">0</xsl:when>
	<xsl:otherwise>6</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:value-of select="count(x:available/x:value[. = current()/x:value]/preceding-sibling::x:*) + $offset"/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>
  <xsl:template match="x:sensors/x:accel/x:filter/x:order/x:value">
    <xsl:text>accel_uifilter_order = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>
  <xsl:template match="x:sensors/x:accel/x:filter/x:low-latency">
    <xsl:text>accel_uifilter_low_latency = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="x:sensors/x:gyro/x:filter/x:bandwidth">
    <xsl:text>gyro_uifilter_bw_int = </xsl:text>
<!--    <xsl:apply-templates select="x:value" mode="filtbw-to-num"/> -->
    <xsl:variable name="offset">
      <xsl:choose>
	<xsl:when test="../x:low-latency = 0">0</xsl:when>
	<xsl:otherwise>6</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:value-of select="count(x:available/x:value[. = current()/x:value]/preceding-sibling::x:*) + $offset"/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>
  <xsl:template match="x:sensors/x:gyro/x:filter/x:order/x:value">
    <xsl:text>gyro_uifilter_order = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>
  <xsl:template match="x:sensors/x:gyro/x:filter/x:low-latency">
    <xsl:text>gyro_uifilter_low_latency = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

</xsl:stylesheet>
