<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns="http://www.w3.org/1999/xhtml"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="text()"/>

  <xsl:template match="/">
    <div>
      <h2 class="tlt">Settings</h2>
      <div class="xc-sl-view"
	   data-view-url="/main/get/files/xml/settings-submenu.xml"
	   data-view-cache="1"
	   data-view-filter="xc.psHTMLC">
      </div>
      <h2 class="tlt">Measurement Settings</h2>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="x:settings">
    <div class="um-settings">
      <form id="settings"
	    action="javascript:meas.submitSettings" method="post"
	    class="xc-action" data-action="meas.initSettings(this, event)">
	<input type="hidden" name="path" value="settings.xml"/>
	<input type="hidden" name="data"/>
	<input type="hidden" name="next_" value="/main/ajax_view?path=settings.xml"/>
      </form>
      <form id="fetch-notch-filter-settings"
	    action="/main/action" method="post">
	<input type="hidden" name="path" value="bin/fetch-sensor-notch-filter-settings.sh"/>
	<input type="hidden" name="next_" value="/main/ajax_view?path=settings.xml"/>
	<input type="hidden" name="csrfmiddlewaretoken" value="{//*/x:cgi/x:csrfmiddlewaretoken}"/>
      </form>
      <form id="calibrate-gyro-sensor"
	    action="/main/action" method="post">
	<input type="hidden" name="path" value="bin/calibrate-gyro-sensor.sh"/>
	<input type="hidden" name="next_" value="/main/ajax_view?path=settings.xml"/>
	<input type="hidden" name="csrfmiddlewaretoken" value="{//*/x:cgi/x:csrfmiddlewaretoken}"/>
      </form>
      <xsl:apply-templates/>
      <input form="settings" type="submit" value="Save" class="tltv"/>
    </div>
  </xsl:template>

  <xsl:template match="x:measurement-program"/>
  <xsl:template match="x:measurement-program" mode="xx">
    <fieldset>
      <legend class="tlt">Measurement program</legend>
      <select name="main-prog">
	<xsl:for-each select="x:alternatives/x:alternative">
	  <option value="{x:name}" class="tlto">
	    <xsl:if test="x:name = ../x:current">
	      <xsl:attribute name="selected">selected</xsl:attribute>
	    </xsl:if>
	    <xsl:value-of select="x:name"/>
	    <xsl:text> - </xsl:text>
	    <xsl:value-of select="x:description"/>
	  </option>
	</xsl:for-each>
      </select>
    </fieldset>
  </xsl:template>

  <xsl:template match="x:interval">
<!--    <fieldset>
      <legend class="tlt">Measurement interval</legend>
      <div class="xc-slider">
	<label for="interval" class="tlt">Measurement interval in seconds</label>
	<input id="interval" name="interval" type="range"
	       min="{x:min}" max="{x:max}" value="{x:value}"/>
	<input id="interval-disp" type="text" value="{x:value}"/>
	<label for="interval-disp">s</label>
      </div>
    </fieldset> -->
  </xsl:template>

<!--  <xsl:template match="x:block-size">
    <fieldset>
      <legend class="tlt">Block size</legend>
      <div class="xc-slider">
	<label for="blocksz" class="tlt">Block size in number of lines</label>
	<input id="blocksz" name="blocksz" type="range"
	       min="{x:min}" max="{x:max}" value="{x:value}"/>
	<input id="blocksz-disp" type="text" value="{x:value}"/>
	<label for="blocksz-disp">s</label>
      </div>
    </fieldset>
  </xsl:template> -->

  <xsl:template match="x:mag" mode="sel-sensor-name"><span class="tlt">Magnetometer</span></xsl:template>
  <xsl:template match="x:accel" mode="sel-sensor-name"><span class="tlt">Accelerometer</span></xsl:template>
  <xsl:template match="x:gyro" mode="sel-sensor-name"><span class="tlt">Gyroscope</span></xsl:template>
  <xsl:template match="x:temp" mode="sel-sensor-name">
    <span class="tlt">Temperature</span>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@index + 1"/>
    <xsl:if test="@index>0">
      <span> (ext.)</span>
    </xsl:if>
  </xsl:template>
  <xsl:template match="x:gashook" mode="sel-sensor-name"><span class="tlt">Gas and particles sensor</span></xsl:template>

  <xsl:template match="x:sensors">
    <fieldset>
      <legend class="tlt">Sensors</legend>
      <div class="xc-checks sensors">
	<xsl:for-each select="x:*">
	  <div>
	    <label for="{local-name()}{@index}"><xsl:apply-templates select="." mode="sel-sensor-name"/></label>
	    <input form="settings" id="{local-name()}{@index}" name="{local-name()}{@index}" type="checkbox" onchange="meas.onChangeSettings(this, event)">
	      <xsl:if test="x:enable>0">
		<xsl:attribute name="checked">checked</xsl:attribute>
	      </xsl:if>
	    </input>
	  </div>
	</xsl:for-each>
      </div>
      <div class="grid-3">
	<div class="sample-rate">
	  <xsl:apply-templates select="../x:sample-rate" mode="select-value"/>
	</div>
	<div class="full-precision">
	  <xsl:apply-templates select="../x:full-precision" mode="enable-value"/>
	</div>
	<div class="packet-decimation">
	  <xsl:apply-templates select="../x:packet-decimation" mode="enter-value">
	    <xsl:with-param name="post-txt" select="'values'"/>
	    <xsl:with-param name="size" select="3"/>
	  </xsl:apply-templates>
	</div>
      </div>
      <div class="grid-3">
	<div class="effsrate">
	  <span class="tlt">Eff. sample rate</span>
	  <input class="tlnv" form="settings" disabled="disabled" type="text" name="effsrate" size="5"/>
	  <span> Hz</span>
	</div>
	<div class="datarate">
	  <span class="tlt">Data rate</span>
	  <input class="tlnv" form="settings" disabled="disabled" type="text" name="datarate" size="5"/>
	  <span> kB/s</span>
	</div>
	<div><!-- <button class="oc-head tlt" data-target="axes-expert">Advanced</button> --> </div>
      </div>
<!--      <div id="axes-expert" class="oc-body">
	<p class="tlt">Invert Axes</p>
	<div class="grid-3">
	  <xsl:for-each select="../x:axes/x:invert">
	    <div>
	      <xsl:apply-templates select="x:enable" mode="enable-value">
		<xsl:with-param name="name">axes-invert-<xsl:value-of select="x:axis"/></xsl:with-param>
	      </xsl:apply-templates>
	    </div>
	  </xsl:for-each>
	</div>
      </div> -->
    </fieldset>

    <fieldset>
      <legend class="tlt">Accelerometer</legend>
      <div class="grid-2-8_2">
	<fieldset>
	  <legend class="tlt">Measurement range</legend>
	  <div class="flex">
	    <xsl:apply-templates select="x:accel/x:range" mode="select-value">
	      <xsl:with-param name="disabled" select="../x:full-precision != 0"/>
	    </xsl:apply-templates>
	    <xsl:apply-templates select="x:accel/x:resolution" mode="select-value">
	      <xsl:with-param name="disabled">1</xsl:with-param>
	      <xsl:with-param name="selected-index">
		<xsl:choose>
		  <xsl:when test="../x:full-precision != 0">2</xsl:when>
		  <xsl:otherwise>1</xsl:otherwise>
		</xsl:choose>
	      </xsl:with-param>
	    </xsl:apply-templates>
	    <xsl:apply-templates select="x:accel/x:unit" mode="select-value"/>
	  </div>
	</fieldset>
	<div><button class="oc-head tlt" data-target="accel-expert">Advanced</button></div>
      </div>
      <div id="accel-expert" class="oc-body">
      <fieldset>
	<legend class="tlt">Anti-aliasing filter</legend>
	<div class="flex">
	  <xsl:apply-templates select="x:accel/x:aa-filter/x:enable" mode="enable-value"/>
	  <xsl:apply-templates select="x:accel/x:aa-filter/x:bandwidth" mode="enter-value">
	    <xsl:with-param name="disabled" select="x:accel/x:aa-filter/x:enable = 0"/>
	  </xsl:apply-templates>
	</div>
      </fieldset>
      <fieldset>
	<legend class="tlt">Offset</legend>
	<div class="grid-3">
	  <xsl:for-each select="x:accel/x:offset">
	    <div>
	      <xsl:apply-templates select="." mode="enter-value">
		<xsl:with-param name="name">accel-offset-<xsl:value-of select="x:axis"/></xsl:with-param>
	      </xsl:apply-templates>
	    </div>
	  </xsl:for-each>
	</div>
      </fieldset>
      </div>
      <fieldset>
	<legend class="tlt">Low-pass filter</legend>
	<div class="flex">
	  <xsl:apply-templates select="x:accel/x:filter/x:low-latency" mode="enable-value"/>
	  <xsl:apply-templates select="x:accel/x:filter/x:order" mode="select-value"/>
	  <xsl:apply-templates select="x:accel/x:filter/x:bandwidth" mode="select-value">
	    <xsl:with-param name="translate-opts">1</xsl:with-param>
	  </xsl:apply-templates>
	  <xsl:apply-templates select="x:accel/x:filter/x:eff-bandwidth" mode="enter-value">
	    <xsl:with-param name="disabled">1</xsl:with-param>
	  </xsl:apply-templates>
	</div>
      </fieldset>
    </fieldset>

    <fieldset>
      <legend class="tlt">Gyroscope</legend>
      <div class="grid-2-8_2">
	<fieldset>
	  <legend class="tlt">Measurement range</legend>
	  <div class="flex">
	    <xsl:apply-templates select="x:gyro/x:range" mode="select-value">
	      <xsl:with-param name="disabled" select="../x:full-precision != 0"/>
	    </xsl:apply-templates>
	    <xsl:apply-templates select="x:gyro/x:resolution" mode="select-value">
	      <xsl:with-param name="disabled">1</xsl:with-param>
	      <xsl:with-param name="selected-index">
		<xsl:choose>
		  <xsl:when test="../x:full-precision != 0">2</xsl:when>
		  <xsl:otherwise>1</xsl:otherwise>
		</xsl:choose>
	      </xsl:with-param>
	    </xsl:apply-templates>
	  </div>
	</fieldset>
	<div><button class="oc-head tlt" data-target="gyro-expert">Advanced</button></div>
      </div>
      <div id="gyro-expert" class="oc-body">
      <fieldset>
	<legend class="tlt">Notch filter</legend>
	<p><span class="tlt">Leave blank to use factory trimmed parameters, or</span>
	<input form="fetch-notch-filter-settings" class="tltv" type="submit" value="Fetch"/><span class="tlt">from sensor</span>.</p>
	<div class="flex">
	  <xsl:apply-templates select="x:gyro/x:notch-filter/x:enable" mode="enable-value"/>
	  <xsl:apply-templates select="x:gyro/x:notch-filter/x:bandwidth" mode="select-value">
	    <xsl:with-param name="disabled" select="x:gyro/x:aa-filter/x:enable = 0"/>
	  </xsl:apply-templates>
	</div>
	<div>
	  <span class="tlt">Center frequency</span>
	</div>
	<div class="grid-3">
	  <xsl:for-each select="x:gyro/x:notch-filter/x:center">
	    <div>
	      <xsl:apply-templates select="." mode="enter-value">
		<xsl:with-param name="name">gyro-notch-filter-center-<xsl:value-of select="x:axis"/></xsl:with-param>
		<xsl:with-param name="disabled" select="../x:enable = 0"/>
	      </xsl:apply-templates>
	    </div>
	  </xsl:for-each>
	</div>
      </fieldset>
      <fieldset>
	<legend class="tlt">Anti-aliasing filter</legend>
	<div class="flex">
	  <xsl:apply-templates select="x:gyro/x:aa-filter/x:enable" mode="enable-value"/>
	  <xsl:apply-templates select="x:gyro/x:aa-filter/x:bandwidth" mode="enter-value">
	    <xsl:with-param name="disabled" select="x:gyro/x:aa-filter/x:enable = 0"/>
	  </xsl:apply-templates>
	</div>
      </fieldset>
      <fieldset>
	<legend class="tlt">Offset</legend>
	<p>
	  <input form="calibrate-gyro-sensor" class="tltv" type="submit" value="Calibrate"/><span class="tlt">gyroscope offsets</span>.</p>
	<div class="grid-3">
	  <xsl:for-each select="x:gyro/x:offset">
	    <div>
	      <xsl:apply-templates select="." mode="enter-value">
		<xsl:with-param name="name">gyro-offset-<xsl:value-of select="x:axis"/></xsl:with-param>
	      </xsl:apply-templates>
	    </div>
	  </xsl:for-each>
	</div>
      </fieldset>
      </div>
      <fieldset>
	<legend class="tlt">Low-pass filter</legend>
	<div class="flex">
	  <xsl:apply-templates select="x:gyro/x:filter/x:low-latency" mode="enable-value"/>
	  <xsl:apply-templates select="x:gyro/x:filter/x:order" mode="select-value"/>
	  <xsl:apply-templates select="x:gyro/x:filter/x:bandwidth" mode="select-value">
	    <xsl:with-param name="translate-opts">1</xsl:with-param>
	  </xsl:apply-templates>
	  <xsl:apply-templates select="x:gyro/x:filter/x:eff-bandwidth" mode="enter-value">
	    <xsl:with-param name="disabled">1</xsl:with-param>
	  </xsl:apply-templates>
	</div>
      </fieldset>
    </fieldset>

  </xsl:template>


  <xsl:template match="x:*" mode="prop-name">
    <xsl:value-of select="local-name()"/>
  </xsl:template>
  <xsl:template match="x:sample-rate" mode="prop-name">Sample rate</xsl:template>
  <xsl:template match="x:range" mode="prop-name">Measurement range</xsl:template>
  <xsl:template match="x:filter" mode="prop-name">Low Pass Filter</xsl:template>
  <xsl:template match="x:bandwidth" mode="prop-name">Band width</xsl:template>
  <xsl:template match="x:eff-bandwidth" mode="prop-name">Eff. bandwidth</xsl:template>
  <xsl:template match="x:unit" mode="prop-name">Unit</xsl:template>
  <xsl:template match="x:correction" mode="prop-name">Correction</xsl:template>
  <xsl:template match="x:offset|x:center" mode="prop-name"><xsl:value-of select="x:axis"/></xsl:template>
  <xsl:template match="x:enable" mode="prop-name">Enable</xsl:template>
  <xsl:template match="x:order" mode="prop-name">Order</xsl:template>
  <xsl:template match="x:low-latency" mode="prop-name">Low latency</xsl:template>
  <xsl:template match="x:full-precision" mode="prop-name">Full precision</xsl:template>
  <xsl:template match="x:resolution" mode="prop-name">Resolution</xsl:template>
  <xsl:template match="x:packet-decimation" mode="prop-name">Output 1 of</xsl:template>
  <xsl:template match="x:invert/x:enable" mode="prop-name"><xsl:value-of select="../x:axis"/></xsl:template>

  <xsl:template match="x:*" mode="input-name">
    <xsl:if test="local-name(../..) != 'sensors' and local-name(../..) != 'settings' and local-name(../..) != 'cont'">
      <xsl:value-of select="concat(local-name(../..), '-')"/>
    </xsl:if>
    <xsl:if test="local-name(..) != 'sensors' and local-name(..) != 'settings'">
      <xsl:value-of select="concat(local-name(..), '-')"/>
    </xsl:if>
    <xsl:value-of select="local-name()"/>
  </xsl:template>

  <xsl:template match="x:*" mode="enable-value">
    <xsl:param name="title">
      <span class="tlt">
	<xsl:apply-templates select="." mode="prop-name"/>
      </span>
    </xsl:param>
    <xsl:param name="name">
      <xsl:apply-templates select="." mode="input-name"/>
    </xsl:param>
    <xsl:variable name="this" select="."/>
    <div>
      <label for="{$name}"><xsl:copy-of select="$title"/></label>
      <input form="settings" id="{$name}" name="{$name}" type="checkbox" onchange="meas.onChangeSettings(this, event)">
	<xsl:if test=". > 0">
	  <xsl:attribute name="checked">checked</xsl:attribute>
	</xsl:if>
      </input>
    </div>
  </xsl:template>

  <xsl:template match="x:*" mode="enter-value">
    <xsl:param name="disabled"/>
    <xsl:param name="post-txt"/>
    <xsl:param name="title">
      <span class="tlt">
	<xsl:apply-templates select="." mode="prop-name"/>
      </span>
    </xsl:param>
    <xsl:param name="name">
      <xsl:apply-templates select="." mode="input-name"/>
    </xsl:param>
    <xsl:param name="size" select="10"/>
    <xsl:variable name="this" select="."/>
    <div>
      <label for="{$name}"><xsl:copy-of select="$title"/></label>
      <input form="settings" id="{$name}" name="{$name}" type="text"
	     class="tlnv" value="{x:value}"
	     title="{x:range/x:value[1]} ... {x:range/x:value[2]} {@unit}"
	     data-range-min="{x:range/x:value[1]}" data-range-max="{x:range/x:value[2]}"
	     size="{$size}"
	     onchange="meas.onChangeSettings(this, event)">
	<xsl:if test="$disabled">
	  <xsl:attribute name="disabled">disabled</xsl:attribute>
	</xsl:if>
      </input>
      <span><xsl:value-of select="@unit"/></span>
      <label for="{$name}">
	<span class="tlt">
	  <xsl:copy-of select="$post-txt"/>
	</span>
      </label>
    </div>
  </xsl:template>

  <xsl:template match="x:*" mode="select-value">
    <xsl:param name="name">
      <xsl:apply-templates select="." mode="input-name"/>
    </xsl:param>
    <xsl:param name="disabled"/>
    <xsl:param name="selected-index"/>
    <xsl:param name="translate-opts"/>
    <xsl:variable name="this" select="."/>
    <div>
      <label for="{$name}">
	<span class="tlt">
	  <xsl:apply-templates select="." mode="prop-name"/>
	</span>
      </label>
      <select form="settings" id="{$name}" name="{$name}" onchange="meas.onChangeSettings(this, event)">
	<xsl:if test="$disabled">
	  <xsl:attribute name="disabled">disabled</xsl:attribute>
	</xsl:if>
	<xsl:for-each select="x:available/x:value">
	  <option value="{.}">
	    <xsl:if test="$translate-opts">
	      <xsl:attribute name="class">tlto</xsl:attribute>
	    </xsl:if>
	    <xsl:if test=". = ../../x:value or string($selected-index) and $selected-index = position()">
	      <xsl:attribute name="selected">selected</xsl:attribute>
	    </xsl:if>
	    <xsl:value-of select="."/>
	    <xsl:if test="string(.) and $this/@unit">
	      <xsl:text> </xsl:text>
	      <xsl:value-of select="$this/@unit"/>
	    </xsl:if>
	  </option>
	</xsl:for-each>
      </select>
    </div>
  </xsl:template>

</xsl:stylesheet>
