<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns="http://www.w3.org/1999/xhtml"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="text()"/>

  <xsl:template match="/">
    <div class="measurement-result-files">
      <div id="result-view">
	<div id="result-dispsels"></div>
	<div id="result-dispopts"></div>
	<div id="result-nmeas"></div>
	<div class="charts">
	  <table id="container_0" class="container_0"></table>
	  <div id="container_1" class="chart-container"></div>
	  <div id="container_2" class="chart-container"></div>
	  <div id="container_3" class="chart-container"></div>
	  <div id="container_4" class="chart-container"></div>
	  <div id="container_5" class="chart-container"></div>
	  <div id="container_6" class="chart-container"></div>
	  <div id="container_7" class="chart-container"></div>
	  <div id="container_8" class="chart-container"></div>
	  <div id="container_9" class="chart-container"></div>
	  <div id="container_3d" class="chart-container"></div>
	</div>
      </div>
      <div id="event-view">
      </div>
      <div class="measurement-result-file-list">
	<xsl:apply-templates/>
      </div>
    </div>
  </xsl:template>

  <xsl:template match="finfo">
    <form id="deleteitems" action="/main/delete">
      <input type="hidden" name="next_" value="/main/ajax_view?path=measurements.xml"/>
      <input type="hidden" name="multiple" value="1"/>
    </form>
    <table class="collection">
      <thead>
	<tr>
	  <td colspan="3">
	    <xsl:value-of select="count(item[not(starts-with(name, '.'))])"/>
	    <xsl:text> </xsl:text>
	    <span class="tlt">Items</span>
	  </td>
	  <td colspan="3">
	    <input form="deleteitems" type="submit" class="tltv" value="Delete selected"/>
	  </td>
	</tr>
	<tr>
	  <!-- <td>
	    <input type="checkbox" name="selall"/>
	  </td> -->
	  <th class="tlt sort-col sort-descending" onclick="return xc.sortCol(event)">Name</th>
	  <th class="tlt sort-col" onclick="return xc.sortCol(event)">Size</th>
	  <th class="tlt sort-col" onclick="return xc.sortCol(event)">Date</th>
	  <th colspan="2">
	  </th>
	  <th>
	    <input type="checkbox" name="selall" onchange="meas.measListSelectAll(event)"/>
	  </th>
	</tr>
      </thead>
      <tbody>
	<xsl:apply-templates select="item[not(starts-with(name, '.'))]">
	  <xsl:sort select="name" order="descending" data-type="text"/>
	</xsl:apply-templates>
      </tbody>
    </table>
  </xsl:template>

  <xsl:template match="finfo/item">
    <tr>
      <td>
	<a>
	  <xsl:attribute name="href">
	    <xsl:choose>
	      <!-- href="javascript:meas.loadMeasurement('{path}')" -->
	      <xsl:when test="contains(path, '-events')">
		<xsl:text>javascript:meas.loadEvents('</xsl:text>
		<xsl:value-of select="path"/>
		<xsl:text>', event)</xsl:text>
	      </xsl:when>
	      <xsl:when test="contains(path, '-slow')">
		<xsl:text>javascript:meas.loadSlowMeasurement('</xsl:text>
		<xsl:value-of select="path"/>
		<xsl:text>', this, event)</xsl:text>
	      </xsl:when>
	      <xsl:otherwise>
		<xsl:text>javascript:meas.loadMeasurement('</xsl:text>
		<xsl:value-of select="path"/>
		<xsl:text>', this, event)</xsl:text>
	      </xsl:otherwise>
	    </xsl:choose>
	  </xsl:attribute>
	  <xsl:value-of select="name[. != '']|path"/>
	</a>
      </td>
      <td class="unit-value">
	<span class="value-with-unit" data-unit="B" data-targetunit="MB">
	  <span class="value"><xsl:value-of select="statdict/st_size"/></span>
	  <span class="unit">&#xa0;B</span>
	</span>
      </td>
      <td><span class="unixtm"><xsl:value-of select="statdict/st_mtime"/></span></td>
      <td>
	<a class="xc-nocatch" href="/main/download/{path}">
	  <img src="/main/download/files/img/download.svg" alt="Download" class="tlta"></img>
	</a>
      </td>
      <!--      <td><a class="xc-nocatch tlt" href="/main/download/{path}">Download</a></td> -->
      <td>
	<a href="/main/delete?path={path}&amp;next_=/main/ajax_view%3Fpath=measurements.xml">
	  <img src="/main/download/files/img/delete.svg" alt="Delete" class="tlta"/>
	</a>
      </td>
      <td>
	<input form="deleteitems" type="checkbox" name="path" value="{path}"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="lsl">
    <div class="file-info">
      <xsl:apply-templates select="finfo"/>
    </div>
  </xsl:template>

</xsl:stylesheet>
