<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns="http://www.w3.org/1999/xhtml"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="text()"/>

  <xsl:template match="/">
    <div>
      <h2 class="tlt">Measurement Process Control</h2>
      <div>
	<form class="inline-block" action="/main/action" method="post">
	  <input type="hidden" name="path" value="bin/start-measurement.sh"/>
	  <input class="tltv" type="submit" value="Start Measurement"/>
	  <input type="hidden" name="next_" value="/main/ajax_view?path=measurement.xml&amp;v=control-view"/>
	  <input type="hidden" name="csrfmiddlewaretoken" value="{//*/x:cgi/x:csrfmiddlewaretoken}"/>
	</form>
	<form class="inline-block" action="/main/action" method="post">
	  <input type="hidden" name="path" value="bin/stop-measurement.sh"/>
	  <input class="tltv" type="submit" value="Stop Measurement"/>
	  <input type="hidden" name="next_" value="/main/ajax_view?path=measurement.xml&amp;v=control-view"/>
	  <input type="hidden" name="csrfmiddlewaretoken" value="{//*/x:cgi/x:csrfmiddlewaretoken}"/>
	</form>
	<div>
	  <xsl:apply-templates select="//x:measurement/x:file"/>
	  <xsl:apply-templates select="//x:measurement/x:pid"/>
	  <xsl:apply-templates select="//x:measurement/x:log"/>
	</div>
      </div>
      <div>
	<fieldset>
	  <legend class="tlt">Device Control</legend>
	  <div class="grid-2">
	    <form class="inline-block" data-form-submit-background="1" action="/main/action" method="post">
	      <input type="hidden" name="path" value="bin/shutdown.sh"/>
	      <input class="tltv" type="submit" value="Shut down uSense"/>
	      <input type="hidden" name="next_" value="/main/ajax_view?path=measurement.xml&amp;v=control-view"/>
	      <input type="hidden" name="csrfmiddlewaretoken" value="{//*/x:cgi/x:csrfmiddlewaretoken}"/>
	    </form>
	    <div>
	      <form class="inline-block" data-form-submit-background="1" action="/main/action" method="post">
		<input type="hidden" name="path" value="bin/reboot.sh"/>
		<input class="tltv" type="submit" value="Restart uSense"/>
		<input type="hidden" name="next_" value="/main/ajax_view?path=measurement.xml&amp;v=control-view"/>
		<input type="hidden" name="csrfmiddlewaretoken" value="{//*/x:cgi/x:csrfmiddlewaretoken}"/>
	      </form>
	      <span class="xc-sl-poll led green" data-poll-url="/main/getf/measurements.xml"
		    id="status-online"
		    data-postprocess="xc.psNonEmptySetClass('on', 'off')"
		    data-poll-timeout="500"
		    data-poll-interval="500">
	      </span>
	    </div>
	  </div>
	  <div class="flexv">
	    <div>
	      <h4 class="tlt">Disk status</h4>
	      <code class="xc-sl-poll pre mono" data-poll-url="/main/plain_status?path=bin/dfh.sh"
		    data-postprocess="xc.psHead(2)"
		    id="status-dfh"
		    data-poll-interval="10000">
	      </code>
	    </div>
	    <div>
	      <h4 class="tlt">Network status</h4>
	      <code class="xc-sl-poll pre mono" data-poll-url="/main/plain_status?path=bin/ifconfig.sh"
		    data-postprocess="xc.psHead(4)"
		    id="status-ifconfig"
		    data-poll-interval="1000">
	      </code>
	    </div>
	  </div>
	</fieldset>
      </div>
    </div>
  </xsl:template>

  <xsl:template match="x:file">
    <div>
	<span class="tlt">Result file</span>
	<xsl:text>: </xsl:text>
	<xsl:value-of select="."/>
    </div>
  </xsl:template>

  <xsl:template match="x:log">
    <div class="log">
      <div class="log-file">
	<span class="tlt">Log file</span>
	<xsl:text> </xsl:text>
	<a class="xc-nocatch" href="/main/download/{.}"><xsl:value-of select="."/></a>
      </div>
<!--      <br/>
      <code class="xc-sl-poll pre" data-poll-url="/main/tail?path={.}&amp;n=4"
	  data-postprocess="psText"
	  id="meas-log"
	  data-poll-interval="1000">
      </code> -->
    </div>
  </xsl:template>

  <xsl:template match="x:pid">
    <div class="measurement-process">
      <div class="measurement-process-info">
	<table class="measurement-processes-table">
	  <thead>
	    <tr>
	      <th>PID</th>
	      <th>CPU (%)</th>
	      <th><span class="tlt">Memory</span> (%)</th>
	      <th class="tlt">Duration</th>
	      <th class="tlt">CPU time</th>
	    </tr>
	  </thead>
	  <tbody class="xc-sl-poll"
		 data-poll-url="/main/plain_status?path=bin/get-pstree.sh&amp;reply=xml"
		 data-id="meas-ps-pidlist-"
		 data-poll-filter="pidrows.xsl"
		 data-poll-method="get"
		 data-poll-delay="250"
		 data-poll-interval="5000">
	    <tr>
	      <td>1</td>
	    </tr>
	  </tbody>
	</table>
      </div>
<!--      <button class="oc-head tlt">More</button>
      <div class="oc-body">
	<table class="measurement-processes-details-table">
	  <thead>
	    <tr>
	      <th>PID</th>
	      <th><span class="tlt">Started</span> (UTC)</th>
	      <th><span class="tlt">Command line</span></th>
	    </tr>
	  </thead>
	  <tbody class="xc-sl-poll"
		 data-poll-url="/main/plain_status?path=bin/get-pstree.sh&amp;reply=xml"
		 data-id="meas-ps-pdetails-"
		 data-poll-filter="pidrows2.xsl"
		 data-poll-method="get"
		 data-poll-interval="5000">
	    <tr>
	      <td>1</td>
	    </tr>
	  </tbody>
	</table>
      </div>-->
    </div>
  </xsl:template>

</xsl:stylesheet>
