<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns="http://www.w3.org/1999/xhtml"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="text()"/>

  <xsl:template match="/">
    <div>
      <h2 class="tlt">Settings</h2>
      <div class="xc-sl-view"
	   data-view-url="/main/get/files/xml/settings-submenu.xml"
	   data-view-cache="1"
	   data-view-filter="xc.psHTMLC">
      </div>
      <h2 class="tlt">Email Settings</h2>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="x:email-settings">
    <div class="um-email-settings">
      <form action="javascript:meas.submitEmailSettings" method="post">
	<fieldset>
	  <legend class="tlt">Configure Email settings</legend>
	  <label for="email-from-email" class="tlt">From Email</label>
	  <input id="email-from-email" type="text" name="email-from" value="{x:from}"
		 size="{string-length(x:from)}"/>
	  <br/>
	  <label for="email-host" class="tlt">Email host</label>
	  <input id="email-host" type="text" name="email-host" value="{x:host}"/>
	  <label for="email-port" class="tlt">Email port</label>
	  <input id="email-port" type="text" name="email-port" value="{x:port}"/>
	  <label for="email-encryption" class="tlt">Email encryption</label>
	  <select id="email-encryption" name="email-enc">
	    <option value="none" class="tlt">
	      <xsl:if test="x:enc = 'none'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
	      <xsl:text>None</xsl:text>
	    </option>
	    <option value="ssl" class="tlt">
	      <xsl:if test="x:enc = 'ssl'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
	      <xsl:text>SSL</xsl:text>
	    </option>
	    <option value="tls" class="tlt">
	      <xsl:if test="x:enc = 'tls'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
	      <xsl:text>TLS</xsl:text>
	    </option>
	  </select>
	  <br/>
	  <label for="email-user" class="tlt">Email user</label>
	  <input id="email-user" type="text" name="email-user" value="{x:user}"/>
	  <label for="email-password" class="tlt">Email password</label>
	  <input id="email-password" type="password" name="email-pass" value="{x:pass}"/>
	</fieldset>

	<fieldset>
	  <legend class="tlt">Email recipients</legend>
	  <xsl:if test="x:to">
	    <div style="display: grid; grid-template-columns: auto auto;">
	      <b class="tlt">Delete</b>
	      <b class="tlt">Recipient</b>
	      <xsl:for-each select="x:to">
		<input id="del-email-to-{position()}" type="checkbox"
		       name="del-email-to-{position()}" style="justify-self: center"/>
		<input id="email-to-{position()}" type="text"
		       size="100" name="email-to-{position()}" value="{.}"/>
	      </xsl:for-each>
	    </div>
	    <br/>
	  </xsl:if>
	  <label class="tlt" for="new-email-to">New recipient address</label>
	  <input id="new-email-to" type="text" size="100" name="new-email-to" value=""/>
	</fieldset>
	
	<input type="hidden" name="path" value="email-settings.xml"/>
	<input type="hidden" name="data"/>
	<input type="hidden" name="next_" value="/main/ajax_view?path=email-settings.xml"/>
	<input type="hidden" name="csrfmiddlewaretoken"/>
	<input class="tltv" type="submit" value="Save"/>
      </form>
    </div>

    <!--testemail-->
    <xsl:apply-templates/>

  </xsl:template>

  <xsl:template match="x:testemail">
    <div class="um-send-testemail">
      <form action="/main/action" method="post">
	<fieldset>
	  <legend class="tlt">Test Email</legend>

	  <xsl:apply-templates/>

	  <input type="hidden" name="path" value="bin/send-testemail.sh"/>
	  <input class="tltv" type="submit" value="Send test email"/>
	  <input type="hidden" name="next_" value="/main/ajax_view?path=email-settings.xml"/>
	  <input type="hidden" name="csrfmiddlewaretoken" value="{//*/x:cgi/x:csrfmiddlewaretoken}"/>

	</fieldset>
      </form>
    </div>
  </xsl:template>

  <xsl:template match="x:log">
    <div class="log">
      <div class="log-file">
	<span class="tlt">Log file</span>
	<xsl:text> </xsl:text>
	<a class="xc-nocatch" href="/main/getf/{.}"><xsl:value-of select="."/></a>
      </div>
      <div class="log-text">
	<code class="xc-sl-poll pre" data-poll-url="/main/get?path={.}"
	      data-postprocess="psText"
	      data-poll-interval="500">
	</code>
      </div>
    </div>
  </xsl:template>

</xsl:stylesheet>
