var meas = {}

meas.clickOnTitle = function() {
    var bar = document.querySelector('.xc-pad')
    if (bar.style.visibility != 'visible') {
	bar.style.visibility = 'visible';
    } else {
	bar.style.visibility = 'hidden';
    }
}

meas.range = [1, 4001]

meas.mode = undefined

meas.msgElemId = 'msgs'
meas.message = function(text, type, timeout) {
    var div = document.createElement('div')
    div.innerHTML = '<div class="msg ' + type + '"><span>x</span><span>' + text + '</span></div>'
    var cancel = function(ev) {
	div.innerHTML = ''
	if (div.parentElement) {
	    div.parentElement.removeChild(div)
	}
    }
    div.onclick = cancel
    var target = document.querySelector('#' + meas.msgElemId)
    if (target) {
	target.appendChild(div)
	if (timeout) {
	    setTimeout(cancel, timeout*1000)
	}
    }
    console.log('meas:' + type + ': ' + text)
    return cancel
}

meas.note = function(text, timeout) {
    if (!timeout) timeout = 2
    return meas.message(text, 'note', timeout)
}
meas.warning = function(text, timeout) {
    if (!timeout) timeout = 3
    return meas.message(text, 'warning', timeout)
}
meas.error = function(text, timeout) {
    return meas.message(text, 'error', timeout)
}

meas.updateControls = function(dummy) {
    var x = document.forms['displayRange']
    if (x != undefined) {
	meas.range = meas.updateRange(x)
    }
    meas.doUpdateControls()
}

meas.updateRange = function(x) {
    var rs = Number(x.start.value)
    var bs = Number(x.blocksz.value)
    if (bs < 1) {
	bs = 1
    }
    if (bs > meas.n) {
	bs = meas.n
    }
    var re = rs + bs
    if (re > meas.n+1) {
	re = meas.n+1
    }
    if (rs + bs > meas.n+1) {
	rs = meas.n+1 - bs
    }
    if (rs < 1) {
	rs = 1
    }
    return [rs, re]
}

meas.doUpdateControls1 = function() {
    var dispSelectButtons = ''
    var pinds = meas.headerInfo.pi.slice(1)
    var plainItemNames = pinds.map((k) => meas.headerInfo.names[k])
    var dispItemNames = plainItemNames.map((k) => meas.translateMeasName(k).replace('_', ' '))
    var grtempcols = 'auto'
	var class_1 = plainItemNames.join(',') == meas.mode ? 'xc-active-link' : ''
    dispSelectButtons += '<button class="' + class_1 + '" onclick="meas.loadDiagramNew(\'' + plainItemNames.join(',') + '\')"><span>'
	+ dispItemNames.join('</span> / <span>') + '</span></button>'

    Object.keys(meas.headerInfo.c3).forEach((k) => {
	var item = meas.headerInfo.c3[k]
	var cinds = item.inds
	var itemNames = cinds.map((k) => meas.headerInfo.names[k])


	var class_2 = itemNames.join(',') == meas.mode ? 'xc-active-link' : ''
	dispSelectButtons += '<button class="' + class_2 + '" onclick="meas.loadDiagramNew(\'' + itemNames.join(',') + '\')"><span class="tlt">' + k + '</span> (3D)</button>'
	grtempcols += ' auto'
    })
	var class_3 = 'table' == meas.mode ? 'xc-active-link' : ''
    dispSelectButtons += '<button class="' + class_3 + ' tlt" onclick="meas.loadTable()">Measurements as table</button>'
    grtempcols += ' auto'

    var html = ''
    if (document.querySelector('#live-view') == null) {
	html += '<a class="xc-nocatch tlt" href="#" onclick="meas.hideResultView()">Close</a></br>'
    }
    html += '<div class="settingssubmenu" style="grid-template-columns: ' + grtempcols + ';">' + dispSelectButtons + '</div>'
    xc.inject('result-dispsels', html)
}

meas.doUpdateControls3 = function() {
    var blocksz = meas.range[1]-meas.range[0]
    xc.inject('result-nmeas',
	'<div><p>' + meas.n + ' ' + tl.transl('samples in measurement file') + '</p></div>' +
	'<div class="grid-2">' +
	'<form name="displayMode" onsubmit="return false;">' +
	' <input name="comp3d" type="hidden" value="sep"/>' +
	' <input name="proj3d" type="hidden" value="z"/>' +
	' <label for="border-select"><span class="tlt">Y axis ranges by</span>: </label>' +
	' <select id="border-select" name="borders">' +
	'   <option value="elimit" class="tlt">Limits</option>' +
	'   <option value="wlimit" class="tlt">Warn-Limits</option>' +
	'   <option value="data" class="tlt">Data</option>' +
	' </select>' +
	'</form>' +
	'<form name="displayRange" onsubmit="return false;" ' +
	'onchange="return meas.updateDisplay(this, event)">' +
	'<label for="mrBlocksize">' + tl.transl('Block size') + ': </label>' +
	'<input id="mrBlocksize" type="text" name="blocksz" value="' + blocksz + '"/>' +
	'<label for="mrBlockStart">' + tl.transl('Data range') + ': ' + meas.range[0] + ' - ' + meas.range[1] + '</label>' +
	'&nbsp;&nbsp;<a href="/main/range/' + meas.fname + '?start=' + meas.range[0] + '&end=' + meas.range[1] + '">' +
	 tl.transl('Download data range') + '</a> ' +
	'<input class="slider" id="mrBlockStart" type="range"' +
	' name="start" min="1" max="' + (meas.n+1 - blocksz)  + '" value="' + meas.range[0] + '"/>' +
	      '</form></div></div>'
	     )
}

meas.doUpdateControls = function() {
    meas.doUpdateControls1()
    if (document.querySelector('#live-view') == null) {
	meas.doUpdateControls3()
    }
    tl.update()
}

meas.setDisplayMode = function(x, ev) {
    console.log('Graph display settings invoked')
    var settingsForm = x
    meas.comp3d = x.comp3d.value
    meas.histlength = Number(x.hist.value)
    var livePoll = document.querySelector('#meas-ps-poll')
    if (livePoll) {
	var parts = livePoll.dataset.pollUrl.split('n=')
	livePoll.dataset.pollUrl = parts[0] + 'n=' + meas.histlength
    }
    var indoc = xc.getXDoc(xc.getCGIXML(settingsForm), 'measurement-graph-controls')
    xc.transformAndSaveAs(indoc, ['measurement-graph-controls-update.xsl'], '/measurement-graph-controls.xml', settingsForm, true, function() {
	console.log('Graph display settings saved!')
    })
}

meas.updateDisplay = function(x, event) {
    if (x != undefined) {
	if (x.comp3d != undefined) {
	    meas.comp3d = x.comp3d.value
	}
	if (x.proj3d != undefined) {
	    meas.proj3d = x.proj3d.value
	}
    }
    meas.updateControls(x)
    if (document.querySelector('#live-view') == null) {
	meas.updateData()
    } else {
	meas.updateView()
    }
}

meas.updateData = function() {
    var fname = meas.fname
    xlp.sendGet('/main/range?path=' + fname + '&start=' + meas.range[0] + '&end=' + meas.range[1], function(s, resp) {
	var t0 = (new Date()).getTime()
	var csv = resp.responseText
	var arrayData = xc.readCSV(csv)
	meas.data = arrayData
	meas.parseMeasurementArray(arrayData)
	var t1 = (new Date()).getTime()
	console.log('Load and parse CSV data: ' + (t1 -t0) + ' ms')
	meas.updateView('')
    })
}

meas.getNumMeasurements = function(fname, done) {
    xlp.sendGet('/main/nlines?path=' + fname, function(s, resp) {
	var n = resp.responseXML.getElementsByTagName('n')[0].firstChild.textContent
	meas.n = Number(n)
	if (meas.n > 0)
	    meas.n -= 1
	done()
    })
}

meas.getMeasurementHeaders = function(fname, done) {
    xlp.sendGet('/main/head?path=' + fname + '&n=1', function(s, resp) {
	meas.processHeadline(resp.responseText)
	done()
    })
}

meas.loadMeasurement = function(fname) {
    meas.fname = fname
    meas.getNumMeasurements(fname, function() {
	meas.getMeasurementHeaders(fname, function() {
	    meas.updateDisplay()
	})
    })
}

meas.loadSlowMeasurement = function(fname) {
    meas.loadMeasurement(fname.split('-slow').join(''))
}

meas.parseMeasurementArray = function(a) {
    var ddict = {}
    Object.keys(meas.headerInfo.names).map((k) => {
	ddict[meas.headerInfo.names[k]] = a[k]
    })
    meas.dataDict = ddict
    meas.time = ddict[meas.headerInfo.names[0]]
}

meas.show = function(ref) {
    var el = document.querySelector(ref)
    if (el) el.style.removeProperty('display')
}

meas.hide = function(ref) {
    var el = document.querySelector(ref)
    if (el) el.style['display'] = 'none'
}

meas.hideChildren = function(ref) {
    var el = document.querySelector(ref).children
    for (var k = 0; k < el.length; ++k) {
	el[k].style['display'] = 'none'
    }
}

meas.updateView = function() {
    if (meas.mode == 'table') {
	meas.loadTable()
    } else {
	meas.loadDiagramNew(meas.mode)
    }
}

meas.loadDiagramNew = function(itemstr) {
    if (itemstr == undefined) {
	itemstr = meas.headerInfo.pi.slice(1).map((k) => meas.headerInfo.names[k]).join(',')
    }
    var items = itemstr.split(',')
    if (meas.dataDict == undefined) return

    var inds = items.map((k) => meas.headerInfo.names.indexOf(k))
    var data = items.map((k) => meas.dataDict[k])
    var names = inds.map((k) => meas.headerInfo.names[k])
    var units = inds.map((k) => meas.headerInfo.units[k])

    if (meas.headerInfo.pi.indexOf(inds[0]) > -1) {
	meas.mk3plotsNew(data, meas.time, names, units)
    } else {
	meas.mk3plotsNew3D(data, meas.time, names, units)
    }

    meas.mode = itemstr
}
var white = '#fff'
var grey = '#808080'
var violet_semi = '#002cd950'
// var blue_semi   = '#a0ccf950'
// var cyan_semi   = '#bee6ff50'
// var green_semi  = '#2d990015'
// var orange_semi = '#ffc98150'
// var red_semi    = '#ff7c7c50'

var blue_semi   = '#0000ff40'
var cyan_semi   = '#0080ff40'
var green_semi  = '#00FF0020'
var orange_semi = '#ff800040'
var red_semi    = '#ff000040'

meas.plotBGColor = white
meas.paperBGColor = white
meas.lineColor = grey
meas.fontColor = '#282e1f'

meas.borders = undefined
meas.warnRange = 0.10
meas.loadBorders = function(done) {
    xlp.loadJSON('/main/get?path=/etc/limits.json', function(res) {
	if (res != 0) {
	    meas.setBorders(res)
	}
	done()
    })
}

meas.loadDefaultBorders = function(done) {
    if (meas.defaultBorders) {
	done()
    } else {
	xlp.loadJSON('/main/get?path=/etc/default-limits.json', function(res) {
	    if (res != 0) {
		meas.defaultBorders = res
	    }
	    done()
	})
    }
}

meas.intintsec = function(a, b) {
    return a[1] > b[0] && b[1] > a[0]
}

meas.inint = function(a, v) {
    return a[1] > v && a[0] <= v
}

meas.encininttr = function(a, v) {
    return a[1] > v.max && a[0] <= v.min
}

meas.ininttr = function(a, v) {
    return !(a[0] > v.max || a[1] < v.min)
}

meas.findint = function(ints, v) {
    var res = -1
    Object.keys(ints).forEach((k) => {
	var intv = ints[k]
	if (meas.inint(intv, v)) {
	    res = k
	}
    })
    return res
}

meas.findinttrgns = function(ints, v) {
    var res = []
    Object.keys(ints).forEach((k) => {
	var intv = ints[k]
	if (meas.ininttr(intv, v)) {
	    res.push(k-2)
	}
    })
    return res
}

meas.findinttr = function(ints, v) {
    var rngs = meas.findinttrgns(ints, v)
    var res = -1
    var maxl = -1
    Object.keys(rngs).forEach((k) => {
	if (Math.abs(rngs[k]) > maxl) {
	    res = rngs[k]+2
	    maxl = Math.abs(rngs[k])
	}
    })
    return res
}

meas.inttype = function(k) {
    if (k == 0) return 'alarm-low'
    else if (k == 1) return 'warn-low'
    else if (k == 2) return 'ok'
    else if (k == 3) return 'warn-high'
    else if (k == 4) return 'alarm-high'
}

meas.normAccel = 9.80665

meas.getUnit = function(name, headerInfo) {
    if (headerInfo == undefined) {
	headerInfo = meas.headerInfo
    }
    var vi = headerInfo.names.indexOf(name)
    var unit = headerInfo.units[vi]
    if (unit)
	unit = unit.substring(1, unit.length-1)
    return unit
}

meas.setBorders = function(data) {
    meas.borders = data
    for (b in meas.borders) {
	var ent = meas.borders[b]
	var unit = meas.getUnit(b)
	if (unit == '(m/s²)') {
	    ent.min *= meas.normAccel
	    ent.wmin *= meas.normAccel
	    ent.wmax *= meas.normAccel
	    ent.max *= meas.normAccel
	}
	ent.intervals = []
	ent.intervals.push([-Infinity, ent.min])
	ent.intervals.push([ent.min, ent.wmin])
	ent.intervals.push([ent.wmin, ent.wmax])
	ent.intervals.push([ent.wmax, ent.max])
	ent.intervals.push([ent.max, Infinity])
    }
}


meas.mk3plotsNew = function(data, time, names, units) {

    if (meas.borders == undefined) {
	meas.loadBorders(function() {
	    meas.mk3plotsNew(data, time, names, units)
	})
	return
    }

    var rangeByData = false, rangeByErrors = false
    if (document.forms['displayMode'] != undefined) {
	if (document.forms['displayMode'].borders.value == 'data') {
	    rangeByData = true
	} else if (document.forms['displayMode'].borders.value == 'elimit') {
	    rangeByErrors = true
	}
    }

    if (! document.querySelector('#container_0')) {
	console.log('not on graph page any more')
	return
    }

    meas.hide('#container_0')
    meas.show('#container_1')
    meas.show('#container_2')
    meas.show('#container_3')
    meas.show('#container_4')
    meas.show('#container_5')
    meas.show('#container_6')
    meas.show('#container_7')
    meas.hide('#container_3d')

    var start = 0, end = -1
    if (end == -1) { end = data[0].length }

    Object.keys(data).forEach((k) => {
	var xdata = time.slice(start, end)
	xdata = xdata.map((k)=>k*1000.0)
	var xmin = xdata[0]
	var xmax = xdata[xdata.length-1]
	var ydata = data[k].slice(start, end)
	var ydatlims = [Math.min(...ydata), Math.max(...ydata)]

	var cid = 'container_' + (Number(k)+1)
	var pelem = document.querySelector('#' + cid)
	var pfun = Plotly.newPlot
	var shapes = []
	var border = meas.borders[names[k]]
	var colors = [ blue_semi, cyan_semi, green_semi, orange_semi, red_semi ]
	var lineCol = meas.lineColor
	if (border) {
	    var intsShown = []
	    var intsTouched = []
	    Object.keys(border.intervals).forEach((ii) => {
		var intv = border.intervals[ii]
		intsShown.push(meas.intintsec(ydatlims, intv))
		intsTouched.push(meas.intintsec(ydatlims, intv))
	    })
	    if (!rangeByData) {
		if (rangeByErrors) {
		    intsShown[3] = 1
		    intsShown[2] = 1
		    intsShown[1] = 1
		}
		if (intsShown[4]) {
		    intsShown[3] = 1
		    intsShown[2] = 1
		} else if (intsShown[3]) {
		    intsShown[2] = 1
		} else if (intsShown[1]) {
		    intsShown[2] = 1
		} else if (intsShown[0]) {
		    intsShown[1] = 1
		    intsShown[2] = 1
		}
	    }
	    Object.keys(border.intervals).forEach((ii) => {
		if (intsShown[ii]) {
		    var intv = border.intervals[ii]
		    const y0 = rangeByData ? Math.max(ydatlims[0], intv[0]) : (Math.abs(intv[0]) == Infinity ? ydatlims[0] : intv[0])
		    const y1 = rangeByData ? Math.min(ydatlims[1], intv[1]) : (Math.abs(intv[1]) == Infinity ? ydatlims[1] : intv[1])
		    const shape = {
			type: 'rect', fillcolor: colors[ii],
			line: {color: 'transparent'},
			xref: 'x', yref: 'y',
			x0: xmin, x1: xmax, y0: y0, y1: y1
		    }
		    shapes.push(shape)
		}
	    })
	}
	var trace = {
	    x: xdata,
	    y: ydata,
	    mode: 'lines',
	    name: names[k],
	    line: {
		color: lineCol,
		width: 1.3
	    }
	}
	var layout = {
	    paper_bgcolor: meas.paperBGColor,
	    plot_bgcolor: meas.plotBGColor,
	    hoverlabel: { bgcolor: 'white' },
	    font:  { color: meas.fontColor },
	    title: { text: meas.translateMeasName(names[k]).replace('_', ' ') },
	    xaxis: {
		title: tl.transl('Time') + ' (s)',
		type: 'date',
	    },
	    yaxis: {
		title: meas.translateMeasName(names[k]).replace('_', ' ') + ' ' + units[k],
	    },
	    shapes: shapes
	}

	pfun(cid, [trace], layout)
	// pelem.on('plotly_afterplot', function(){
	//     console.log('done plotting: ' + cid);
	// })
    })
    for (var i = data.length; i < 9; ++i) {
	var cid = 'container_' + (i+1)
	var pelem = document.querySelector('#' + cid)
	pelem.innerHTML = ''
    }
}

meas.mk3plotsNew3D = function(data, time, names, units) {

    var mode = ''
    if (document.forms['displayMode'] != undefined) {
	mode = document.forms['displayMode'].comp3d.value
	if (mode != 'aggr') {
	    meas.mk3plotsNew(data, time, names, units)
	    return
	}
    }

    meas.hide('#container_0')
    meas.hide('#container_1')
    meas.hide('#container_2')
    meas.hide('#container_3')
    meas.hide('#container_4')
    meas.hide('#container_5')
    meas.hide('#container_6')
    meas.hide('#container_7')
    meas.show('#container_3d')

    var name = names[0].substr(0, names[0].length-2)
    var unit = units[0]

    var start = 0, end = -1
    if (end == -1) { end = data[0].length }

    var v1 = [1, 0, 0]
    var v2 = [0, 1, 0]
    if (document.forms.displayMode.proj3d != undefined) {
	if (document.forms.displayMode.proj3d.value == 'x') {
	    v1 = [0, 1, 0]
	    v2 = [0, 0, 1]
	} else if (document.forms.displayMode.proj3d.value == 'y') {
	    v1 = [1, 0, 0]
	    v2 = [0, 0, 1]
	} else if (document.forms.displayMode.proj3d.value == 'z') {
	    v1 = [1, 0, 0]
	    v2 = [0, 1, 0]
	}
    }

    var data1 = meas.project3DData(data[0], data[1], data[2], v1)
    var data2 = meas.project3DData(data[0], data[1], data[2], v2)

    var trace1 = {
	x: time.slice(start, end),
	y: data1,
	z: data2,
	mode: 'markers',
	type: 'scatter3d',
	name: name,
	marker: {
	    size: 2,
	    opacity: 0.8,
	    line: {
		color: meas.lineColor,
		width: 0.4
	    }
	},
	line: {
	    color: meas.lineColor,
	    width: 1
	}
    }

    var pelem = document.querySelector('#' + 'container_3d')
    var pfun = Plotly.newPlot
    if (pelem.data != undefined) {
	pfun = Plotly.react
    }

    if (pelem.dataset.hold != 'true') {
	pfun('container_3d', [trace1],
	     { paper_bgcolor: meas.paperBGColor,
	       uirevision: 1,
	       plot_bgcolor: meas.plotBGColor,
	       font: { color: meas.fontColor },
	       title: { text: meas.translateMeasName(name) },
	       scene: {
		   xaxis: { title: tl.transl('Time') + ' (s)', backgroundcolor: meas.plotBGColor,
			    gridcolor: 'rgb(220, 220, 220)',
			    showbackground: true, zerolinecolor: 'rgb(255, 255, 255)', automargin: true  },
		   yaxis: { title: meas.translateMeasName(name).replace(/&#xad;/g, '') + ' ' + unit, backgroundcolor: meas.plotBGColor,
			    gridcolor: 'rgb(220, 220, 220)',
			    showbackground: true, zerolinecolor: 'rgb(255, 255, 255)', automargin: true },
		   zaxis: { title: meas.translateMeasName(name).replace(/&#xad;/g, '') + ' ' + unit, backgroundcolor: meas.plotBGColor,
			    gridcolor: 'rgb(220, 220, 220)',
			    showbackground: true, zerolinecolor: 'rgb(255, 255, 255)', automargin: true }
	       },
	       showlegend: true,
	       autosize: true,
	       width: 750,
	       height: 750,
	       margin: { l: 120, r: 120, b: 20, t: 50, pad: 40 }
	     })
    }
    pelem.onmousedown = function(ev) {
	pelem.dataset.hold = true
    }
    pelem.onmouseup = function(ev) {
	pelem.dataset.hold = false
    }
    pelem.onmouseleave = function(ev) {
	pelem.dataset.hold = false
    }
}

meas.project3DData = function(p1, p2, p3, v) {
    var res = Array(p1.length)
    for (var i = 0; i < p1.length; ++i) {
	res[i] = p1[i]*v[0] + p2[i]*v[1] + p3[i]*v[2]
    }
    return res
}

// Load table //
meas.loadTable = function() {
    meas.show('#container_0')
    meas.hide('#container_1')
    meas.hide('#container_2')
    meas.hide('#container_3')
    meas.hide('#container_4')
    meas.hide('#container_5')
    meas.hide('#container_6')
    meas.hide('#container_7')
    meas.hide('#container_3d')

    var ths = Object.keys(meas.headerInfo.names).map((k) => {
	var name = meas.headerInfo.names[k]
	var tname = meas.translateMeasName(name)
	var parts = tname.split('_')
	if (parts.length>1) {
	    return ['<th>' + parts[0] + ' ' + parts[1] + '</th>', '<th></th>']
	} else {
	    return ['<th>' + parts[0] + '</th>', '<th></th>']
	}
    })
    var thsu = meas.headerInfo.units.map((unit) => '<th>' + unit + '</th>')
    var hrow1 = ths.map((k)=>k[0]).join('')
    var hrow2 = ths.map((k)=>k[1]).join('')
    var hrow3 = thsu.join('')

    var prec = 3
    var rows = []
    for (var j = 0; j < meas.data[0].length; ++j) {
	var tarr = []
	for (var i = 0; i < meas.data.length; ++i) {
	    tarr[i] = meas.data[i][j].toLocaleString(undefined, { maximumFractionDigits: prec })
	}
	rows[j] = tarr.map((item) => '<td>' + item + '</td>').join('')
    }

    var table = '<table class="meastable"><tr class="hrow1">' + hrow1 + '</tr>\n' +
	'<tr class="hrow3">' + hrow3 + '</tr>\n' +
	'<tr>' + rows.join('</tr>\n<tr>') + '</tr></table>'

    var ttarget = document.getElementById('container_0')
    ttarget.innerHTML = table
    meas.mode = 'table'
};

meas.initSettings = function(x, ev) {
    var form = x.document.querySelector('form.xc-action')
    form['sample-rate'].onchange()
    // form['full-precision'].onchange()
    form['accel-filter-bandwidth'].onchange()
    form['gyro-filter-bandwidth'].onchange()

    var dFields = ['effsrate', 'datarate', 'accel-filter-eff-bandwidth', 'gyro-filter-eff-bandwidth']
    for (i in dFields) {
	var key = dFields[i]
	form[key].setAttribute('value', form[key].value)
    }
}

meas.setInputValue = function(x, v) {
    x.value = v
    x.dataset.tdone = 0
}

meas.onChangeSettings = function(x, ev) {
    console.log('onchange settings', x.id)
    var form = x.form
    var updateEffsRate = ()=> {
	var pktType = 1
	if (form['accel'].checked && form['gyro'].checked && form['full-precision'].checked) {
	    pktType = 4
	} else if (form['accel'].checked && form['gyro'].checked) {
	    pktType = 3
	} else if (form['gyro'].checked) {
	    pktType = 2
	} else if (form['accel'].checked) {
	    pktType = 1
	}
	var pktBytes = 8
	if (pktType == 3) {
	    pktBytes = 16
	} else if (pktType == 4) {
	    pktBytes = 20
	}
	var effSR = Number(form['sample-rate'].value) / Number(form['packet-decimation'].value)
	meas.setInputValue(form['effsrate'], effSR)
	var drate = effSR * pktBytes / 1000
	meas.setInputValue(form['datarate'], drate)
	if (drate > 240) {
	    form['datarate'].style.background = '#80000030'
	    form['datarate'].style.border     = '0.1em solid red'
	} else {
	    form['datarate'].style.removeProperty('background')
	    form['datarate'].style.removeProperty('border')
	}
    }
    if (x.id == 'sample-rate') {
	updateEffsRate()
	form['accel-filter-bandwidth'].onchange()
	form['gyro-filter-bandwidth'].onchange()

    } else if (x.id == 'packet-decimation') {
	updateEffsRate()

    } else if (x.id == 'accel') {
	var sr = form['sample-rate']
	if (!x.checked) {
	    if (!form['gyro'].checked) {
		form['gyro'].checked = true
	    }
	    form['full-precision'].checked = false
	    form['full-precision'].onchange()
	}
	updateEffsRate()

    } else if (x.id == 'gyro') {
	var sr = form['sample-rate']
	if (!x.checked) {
	    if (!form['accel'].checked) {
		form['accel'].checked = true
	    }
	    form['full-precision'].checked = false
	    form['full-precision'].onchange()
	}
	updateEffsRate()

    } else if (x.id == 'full-precision') {
	if (x.checked) {
	    form['gyro-resolution'].selectedIndex = 1
	    form['gyro-range'].selectedIndex = 0
	    form['gyro-range'].disabled = true

	    form['accel-resolution'].selectedIndex = 1
	    form['accel-range'].selectedIndex = 0
	    form['accel-range'].disabled = true

	    form['gyro'].checked = true
	    form['accel'].checked = true
	    form['accel'].onchange()
	} else {
	    form['gyro-resolution'].selectedIndex = 0
	    form['gyro-range'].disabled = false
	    form['accel-resolution'].selectedIndex = 0
	    form['accel-range'].disabled = false
	}
	updateEffsRate()

    } else if (x.id == 'accel-aa-filter-enable') {
	form['accel-aa-filter-bandwidth'].disabled = !x.checked
    } else if (x.id == 'gyro-aa-filter-enable') {
	form['gyro-aa-filter-bandwidth'].disabled = !x.checked
    } else if (x.id == 'gyro-notch-filter-enable') {
	form['gyro-notch-filter-bandwidth'].disabled = !x.checked
	form['gyro-notch-filter-center-X'].disabled = !x.checked
	form['gyro-notch-filter-center-Y'].disabled = !x.checked
	form['gyro-notch-filter-center-Z'].disabled = !x.checked

    } else if (x.id == 'gyro-filter-low-latency') {
	var bw = form['gyro-filter-bandwidth']
	if (bw.selectedIndex > 1) {
	    bw.selectedIndex = 1
	}
	bw.onchange()
    } else if (x.id == 'gyro-filter-bandwidth') {
	if (x.selectedIndex > 1) {
	    form['gyro-filter-low-latency'].checked = false
	}
	var sr = Number(form['sample-rate'].value)
	var divi = Number(x.value.split('/')[1])
	var effBW = (sr / divi) / 2
	meas.setInputValue(form['gyro-filter-eff-bandwidth'], effBW)

    } else if (x.id == 'accel-filter-low-latency') {
	var bw = form['accel-filter-bandwidth']
	if (bw.selectedIndex > 1) {
	    bw.selectedIndex = 1
	}
	bw.onchange()
    } else if (x.id == 'accel-filter-bandwidth') {
	if (x.selectedIndex > 1) {
	    form['accel-filter-low-latency'].checked = false
	}
	var sr = Number(form['sample-rate'].value)
	var divi = Number(x.value.split('/')[1])
	var effBW = (sr / divi) / 2
	meas.setInputValue(form['accel-filter-eff-bandwidth'], effBW)

    } else if (x.id == 'temp0') {
	x.checked = true
    }
    tl.update(document)
}

meas.submitSettings = function(ev) {
    var settingsForm = ev.target
    meas.untranslateNValues(settingsForm)
    var valdoc = xc.getCGIXML(settingsForm)
    var updatexlp = xlp.mkXLP(['update-settings.xsl'], '/main/getf/')
    var indoc = xc.getXDoc([valdoc, xc.getMarkup(xc.docs['settings'])].join(''), 'settings-update')
    updatexlp.transform(indoc, function(res) {
	settingsForm.path.value = '/settings.xml'
	settingsForm.data.value = res.documentElement.outerHTML
	settingsForm.csrfmiddlewaretoken.value = xc.getCSRFToken()
	xlp.submitForm(settingsForm, '/main/ajax_edit', function(respdoc, resp) {
	    console.log('XML settings updated and submitted')

	    var updateconfxlp = xlp.mkXLP(['update-settings-conf.xsl'], '/main/getf/')
	    updateconfxlp.transform(res, false, function(resconf) {
		settingsForm.path.value = '/etc/sensorsettings.conf'
		settingsForm.data.value = resconf.textContent
		xlp.submitForm(settingsForm, '/main/ajax_edit', function(status) {
		    console.log('Text config updated and submitted')

		    var updateinixlp = xlp.mkXLP(['update-settings-ini.xsl'], '/main/getf/')
		    updateinixlp.transform(res, false, function(resini) {
			settingsForm.path.value = '/etc/sensorsettings.ini'
			settingsForm.data.value = resini.textContent
			xlp.submitForm(settingsForm, '/main/ajax_edit', function(status) {
			    console.log('Text config updated and submitted')

			    myframes.renderRespHandler(respdoc, resp, function() {
				console.log('XML settings updated: page updated')
				renderPostProc(ev, resp, function (a, b) {
				    meas.note('Settings updated')
				    console.log('Settings updated', a, b)
				}, true)
			    })

			})
		    })
		})
	    })

	})
    })
}

meas.submitWiFiSettings = function(ev) {
    var settingsForm = ev.target
    var valdoc = xc.getCGIXML(settingsForm)
    var updatexlp = xlp.mkXLP(['update-wifi-settings.xsl'], '/main/getf/')
    var indoc = xc.getXDoc([valdoc, xc.getMarkup(xc.docs['wifi-settings'])].join(''), 'wifi-settings-update')
    updatexlp.transform(indoc, function(res) {
	settingsForm.path.value = '/wifi-settings.xml'
	settingsForm.data.value = res.documentElement.outerHTML
	settingsForm.csrfmiddlewaretoken.value = xc.getCSRFToken()
	xlp.submitForm(settingsForm, '/main/ajax_edit', function(respdoc, resp) {

	    console.log('XML settings submitted')

	    myframes.renderRespHandler(respdoc, resp, function() {
		console.log('XML settings updated: page updated')
		renderPostProc(ev, resp)
	    })

	    var updateconfxlp = xlp.mkXLP(['update-wifi-settings-conf.xsl'], '/main/getf/')
	    updateconfxlp.transform(res, false, function(resconf) {
		settingsForm.path.value = '/etc/wpa_supplicant.conf'
		settingsForm.data.value = resconf.textContent
		xlp.submitForm(settingsForm, '/main/ajax_edit', function(status) {
		    console.log('Text config updated and submitted')
		})
	    })

	})
    })
}

meas.untranslateNValues = function(settingsForm) {
    for (var f in settingsForm.elements) {
	var input = settingsForm.elements[f]
	if (input.value) {
	    input.value = input.value.replace(',', '.')
	}
    }
}

meas.submitLimitSettings = function(ev) {
    var settingsForm = ev.target
    meas.untranslateNValues(settingsForm)
    var valdoc = xc.getCGIXML(settingsForm)
    var updatexlp = xlp.mkXLP(['update-limits.xsl'], '/main/getf/')
    var indoc = xc.getXDoc([valdoc, xc.getMarkup(xc.docs['limits'])].join(''), 'limits-update')
    updatexlp.transform(indoc, function(res) {
	settingsForm.path.value = '/limits.xml'
	settingsForm.data.value = res.documentElement.outerHTML
	settingsForm.csrfmiddlewaretoken.value = xc.getCSRFToken()
	xlp.submitForm(settingsForm, '/main/ajax_edit', function(respdoc, resp) {
	    console.log('XML settings submitted')
	    xc.transformAndSaveAs(res, ['update-limits-conf.xsl'], '/etc/limits.json', settingsForm, false, function() {
		myframes.renderRespHandler(respdoc, resp, function() {
		    console.log('XML settings updated: page updated')
		    meas.borders = undefined
		    renderPostProc(ev, resp)
		})
	    })
	})
    })
}

meas.submitEmailSettings = function(ev) {
    var settingsForm = ev.target
    var valdoc = xc.getCGIXML(settingsForm)
    var updatexlp = xlp.mkXLP(['update-email-settings.xsl'], '/main/getf/')
    var indoc = xc.getXDoc(valdoc, 'email-settings-update')
    updatexlp.transform(indoc, function(res) {
	settingsForm.path.value = '/email-settings.xml'
	settingsForm.data.value = res.documentElement.outerHTML
	settingsForm.csrfmiddlewaretoken.value = xc.getCSRFToken()
	xlp.submitForm(settingsForm, '/main/ajax_edit', function(respdoc, resp) {

	    console.log('XML settings submitted')

	    myframes.renderRespHandler(respdoc, resp, function() {
		console.log('XML settings updated: page updated')
		renderPostProc(ev, resp)
	    })

	    var updateconfxlp = xlp.mkXLP(['update-email-settings-conf.xsl'], '/main/getf/')
	    updateconfxlp.transform(res, false, function(resconf) {
		settingsForm.path.value = '/files/py/email_settings.py'
		settingsForm.data.value = resconf.textContent
		xlp.submitForm(settingsForm, '/main/ajax_edit', function(status) {
		    console.log('Text config updated and submitted')
		})
	    })

	})
    })
}

meas.parseMeasurementHeaders = function(text) {
    var line = text.split('#')[1]
    if (line == undefined)
	line = text
    var items = line.split(';')
    return items.map((k) => k.trim())
}

meas.partitionMeasurementHeaders = function(headers) {
    var headParts = headers.map((k) => k.match(/([a-zA-Z0-9_]+)(.*)/))
    var headNames = headParts.map((k) => k[1].trim())
    var headUnits = headParts.map((k) => k[2].trim())

    var c3headers = headNames.map((k) => k.match(/([a-zA-Z0-9]+)_([XYZ])/))
    var pinds = Object.keys(c3headers).filter((k) => c3headers[k] == null)
    pinds = pinds.map((k)=>Number(k))
    var c3inds = Object.keys(c3headers).filter((k) => c3headers[k] != null)
    c3inds = c3inds.map((k)=>Number(k))
    var c3dict = {}
    for (var i = 0; i < c3inds.length; ++i) {
	var cind = c3inds[i]
	var gname = c3headers[cind][1]
	if (c3dict[gname] == undefined) {
	    c3dict[gname] = {name: gname, unit: headUnits[cind], inds: [], vals: []}
	}
	c3dict[gname].inds.push(cind)
    }
    var p1dict = {}
    for (var i = 0; i < pinds.length; ++i) {
	var pind = pinds[i]
	var gname = headNames[pind]
	var parts = gname.split('_')
	var title = parts[0]
	var index = 0
	if (parts.length>1) {
	    index = Number(parts[1])
	}
	p1dict[gname] = {name: gname, title: title, index: index, unit: headUnits[pind], inds: [pind], vals: []}
    }
    var res = {names: headNames, units: headUnits, p1: p1dict, c3: c3dict, pi: pinds, ci: c3inds}
    return res
}

meas.processHeadline = function(text) {
    meas.headline = text
    meas.headers = meas.parseMeasurementHeaders(text)
    meas.headerInfo = meas.partitionMeasurementHeaders(meas.headers)
    meas.borders = undefined
}

meas.psMeasurementHeaders = function(text) {
    if (text.length > 0) {
	meas.processHeadline(text)
	var tds = meas.headers.map((item) => '<span class="valuehead">' + item.trim() + '</span>')
	return tds.join('')
    }
}

function* range(start, end) {
    yield start;
    if (start === end) return;
    yield* range(start + 1, end);
}

meas.plott0 = {}
meas.plottimes = {}

meas.translateMeasName = function(n) {
    var parts = n.split('_')
    var suff = ''
    if (parts.length > 1) {
	n = parts[0]
	suff = '_' + parts[1]
    }
    return tl.transl(n) + suff
}

meas.itranslateMeasName = function(n) {
    var parts = n.split('_')
    var suff = ''
    if (parts.length > 1) {
	n = parts[0]
	suff = '_' + parts[1]
    }
    var res = tl.itransl(n) + suff
    return res
}

meas.psLatestMeasurements = function(text) {

    if (meas.borders == undefined) {
	meas.loadBorders(function() {
	})
	return {noupdate: true}
    }

    var items = text.split(';')
    meas.latest = items
    if (meas.headers == undefined) {
	// while header data has not arrived...
	return {noupdate: true}
    }
    if (text.length == 0) {
	return {noupdate: true}
    }
    if (meas.headers.length != items.length && meas.headers.length*3 != items.length) {
	// sth went wrong, text possibly empty
	console.error('Invalid number of items received', meas.headers.length, items.length)
	return {noupdate: true}
    }

    var titems = []
    var nitems = []
    for (var i = 0; i < items.length; ++i) {
	titems.push(items[i])
	if (i % 3 == 2) {
	    nitems.push({min: titems[0], mean: titems[1], max: titems[2]})
	    titems = []
	}
    }
    items = nitems

    var optsForm = document.forms['latest-val-display-mode']
    if (optsForm == undefined) return ''
    var mode = optsForm['comp3d-select'].value
    var prec = optsForm['precision-select'].value
    var plot = false // optsForm['plot-check'].checked
    var update = optsForm['update-check'].checked

    if (!update)
	return {noupdate: true}

    var values = []
    var min_values = []
    var max_values = []
    var headers = []
    var classes = []
    var ranges = []
    var gridcols = []

    if (mode == 'aggr') {
	var k = 0
	values.push(items[0])
	headers.push(tl.tlelem(meas.headerInfo.names[0]) + ' ' + meas.headerInfo.units[0])
	classes.push(0)
	ranges.push(0)
	gridcols.push(0)
	for (var i in meas.headerInfo.c3) {
	    var c3item = meas.headerInfo.c3[i]
	    var s = {min: 0, mean: 0, max: 0}
	    var atypes = []
	    var border
	    for (var j in c3item.inds) {
		var vi = c3item.inds[j]
		var v = items[vi]
		s.min += v.min*v.min
		s.mean += v.mean*v.mean
		s.max += v.max*v.max
		border = meas.borders[meas.headerInfo.names[vi]]
		if (border) {
		    atypes.push(meas.findinttr(border.intervals, v) - 2)
		} else {
		    atypes.push(0)
		}
	    }
	    var amax = Math.max(...atypes)
	    var amin = Math.min(...atypes)
	    var a = amin
	    if (amax > -amin)
		a = amax
	    classes.push(meas.inttype(a+2))

	    s.min = Math.sqrt(s.min).toPrecision(16)
	    s.mean = Math.sqrt(s.mean).toPrecision(16)
	    s.max = Math.sqrt(s.max).toPrecision(16)
	    values.push(s)
	    headers.push(tl.tlelem(c3item.name) + ' ' + c3item.unit)
	    k += 1
	    ranges.push(0)
	    gridcols.push(k)
	}
	var pinds = meas.headerInfo.pi
	for (var i = 1; i < pinds.length; ++i) {
	    values.push(items[pinds[i]])
	    headers.push(meas.translateMeasName(meas.headerInfo.names[pinds[i]]).replace('_', ' ') + ' ' + meas.headerInfo.units[pinds[i]])
	    var border = meas.borders[meas.headerInfo.names[pinds[i]]]
	    if (border) {
		classes.push(meas.inttype(meas.findinttr(border.intervals, items[pinds[i]])))
		ranges.push(border.wmax - border.wmin)
	    } else {
		classes.push(meas.inttype(2))
		ranges.push(0)
	    }
	    gridcols.push(i-1)
	}
    } else {
	values  = items
	headers = []
	for (var i = 0; i < meas.headers.length; ++i) {
	    var n = meas.translateMeasName(meas.headerInfo.names[i]).replace('_', ' ')
	    headers.push(n + ' ' + meas.headerInfo.units[i])
	    var border = meas.borders[meas.headerInfo.names[i]]
	    if (border) {
		classes.push(meas.inttype(meas.findinttr(border.intervals, items[i])))
		ranges.push(border.wmax - border.wmin)
	    } else {
		classes.push(meas.inttype(2))
		ranges.push(0)
	    }
	}

	gridcols = []
	var kv = 1, ks = 0
	// skip time
	gridcols.push(0)
	for (var i = 1; i < values.length; ++i) {
	    if (meas.headerInfo.pi.indexOf(i) > -1) {
		if (meas.headerInfo.pi.indexOf(i) == meas.headerInfo.pi.length -1) {
		    gridcols.push('' + (ks%3 + 1) + '/4')
		} else {
		    gridcols.push((ks%3) + 1)
		}
		ks += 1
	    } else {
		gridcols.push((kv%3))
		kv += 1
	    }
	}
    }

    var fnum = (k) => k.toLocaleString(undefined, { maximumFractionDigits: prec, minimumFractionDigits: prec })
    var fsec = (k) => k.toLocaleString(undefined, { maximumFractionDigits: prec, minimumIntegerDigits: 2 })
    var fmin = (k) => k.toLocaleString(undefined, { minimumIntegerDigits: 2 })

    values = values.map((k) => { return {min:   Number(k.min),
					 mind:  Number(k.min) - Number(k.mean),
					 mean:  Number(k.mean),
					 maxd:  Number(k.max) - Number(k.mean),
					 max:   Number(k.max),
					 range: Number(k.max) - Number(k.min)
					}
			       })
    var formattedValues = values.map((k) => { return {min:   fnum(k.min),
						      mind:  fnum(k.mind),
						      mean:  fnum(k.mean),
						      maxd:  fnum(k.maxd),
						      max:   fnum(k.max),
						      range: fnum(k.range)
						     }
					    })
    formattedValues[0] = new Date(values[0].mean*1000).toLocaleString()

    headers[0] = tl.tlelem('Time')

    var tds = Object.keys(values).map((k) => {
	var item  = formattedValues[k]
	var nitem = values[k]
	var range = ranges[k]
	var s = '<div>'
	if (nitem.mind != 0 || nitem.maxd != 0 || true) {
	    s = '<div class="value-range">' +
		'<div class="min-value">' + (nitem.mind ? item.mind : '') + '</div>' +
		' <div class="mean-value">' + item.mean + '</div> ' +
		'<div class="max-value">' + (nitem.maxd ? item.maxd : '') + '</div>' +
		'</div>'
	    if (range > 0 || true) {
		var wperc = range > 0 ? (100 * nitem.range / range) : 0, wcol = 'grey'
		if (wperc > 100) {
		    wperc = 100
		    wcol = 'red'
		}
		s += '<div data-perc="' + wperc + '" data-nrange="' + nitem.range + '" data-range="' + range + '" class="mv-bar" style="width: ' + wperc + '%; background: ' + wcol + '">&nbsp;</div>'
	    }
	} else {
	    s = '<div class="value">' + item.mean + '</div>'
	}
	return s
    })
    tds[0] = '<div><span class="value">' +  formattedValues[0] + '</span></div>'
    var sepDone = 0
    Object.keys(tds).forEach((i) => {
	i = Number(i)
	var head = headers[i]
	var row = 0
	if (i == 0) {
	    col = '1/4'
	    row = '1'
	} else {
	    row = Math.floor((i-1)/3) + 2
	    col = gridcols[i]
	}
	var title = 'Min: ' + values[i].min + ' Mean: ' + values[i].mean
	var c3Key = Object.keys(meas.headerInfo.c3).find((k) => {
	    var e = meas.headerInfo.c3[k]
	    return e.inds.indexOf(i) > -1
	})
	if (c3Key && mode != 'aggr') {
	    var e = meas.headerInfo.c3[c3Key]
	    var axi = e.inds.indexOf(i)
	    var html = ''
	    if (axi == 0) {
		html = '<div style="grid-column: 1/4;" class="livevalue-header"><span class="lv-head">' +
		    meas.translateMeasName(e.name) + ' ' + e.unit + '</span></div>'
	    }
	    var axes = ['X', 'Y', 'Z']
	    var ax = axes[axi]
	    html += '<div title="' + title + '" style="grid-column: ' + col + ';" class="livevalue ' + classes[i] + '">' +
		'<span class="lv-head">' + ax + '</span><br/><div class="lv-value">' + tds[i] + '</div></div>'
	    tds[i] = html
	} else {
	    var html = ''
	    if (mode != 'aggr' && i > 0 && sepDone == 0) {
		html += '<div style="grid-column: 1/4;" class="livevalue-header"><span class="lv-head">' +
		    tl.transl('Single values') + '</span></div>'
		sepDone = 1
	    }
	    html += '<div title="' + title + '" style="grid-column: ' + col + ';" class="livevalue ' + classes[i] + '">' +
		'<span class="lv-head">' + head + '</span><br/><div class="lv-value">' + tds[i] + '</div></div>'
	    tds[i] = html
	}
    })

    var ppFuncs = []
    var gtc = ''
    if (!plot) {
	for (var pcount = 0; pcount < 5; ++pcount) {
	    var cid = 'curmeas-plot-' + pcount
	    meas.hide('#' + cid)
	}
    } else {
	var pcount = 0
	Object.keys(meas.headerInfo.c3).forEach(function(i) {
	    var c3item = meas.headerInfo.c3[i]
	    var cid = 'curmeas-plot-' + pcount
	    pcount += 1
	    gtc += ' auto';

	    var xval = items[c3item.inds[0]].mean
	    var yval = items[c3item.inds[1]].mean
	    var zval = items[c3item.inds[2]].mean

	    var trace = {
		x: [0, xval], y: [0, yval], z: [0, zval],
		mode: 'lines+markers',
		type: 'scatter3d',
		name: c3item.name,
		marker: {
		    size: 5,
		    opacity: 0.8,
		    line: { color: meas.lineColor, width: 0.4 }
		},
		line: { color: meas.lineColor, width: 2 },
	    }

	    meas.show('#' + cid)
	    var pelem = document.querySelector('#' + cid)
	    var pfun = Plotly.newPlot
	    var amax = Math.max(Math.abs(xval), Math.abs(yval), Math.abs(zval))
	    meas.plott0[cid] = (new Date()).getTime()
	    if (pelem.dataset.hold != 'true') {
		pfun(cid, [trace],
		     { title: tl.transl(c3item.name) + ' ' + c3item.unit,
		       uirevision: 1,
		       paper_bgcolor: meas.paperBGColor,
		       plot_bgcolor: meas.plotBGColor,
		       font: { color: meas.fontColor },
		       scene: {
			   aspectmode: "manual",
			   aspectratio: {
			       x: 1, y: 1, z: 1,
			   },
			   // annotations: [{
			   //     showarrow: true,
			   //     x: xval, y: yval, z: zval,
			   //     ax: -20, ay: -20, az: -20,
			   //     xshift: 0, yshift: 0, zshift: 0,
			   //     xref: 'x', yref: 'y', zref0: 'z',
			   //     axref: 'x', ayref: 'y', azref0: 'z',
			   //     text: "Test", textangle: 0,
			   //     font: { color: "black", size: 12 },
			   //     arrowhead: 1, arrowsize: 2, arrowcolor: "black", arrowwidth: 1,
			   // }],
			   xaxis: { title: { text: 'X' }, backgroundcolor: meas.plotBGColor, gridcolor: 'rgb(220, 220, 220)',
				    showbackground: true, zerolinecolor: '#444', automargin: true,
				    range: [-amax, amax] },
			   yaxis: { title: { text: 'Y' }, backgroundcolor: meas.plotBGColor, gridcolor: 'rgb(220, 220, 220)',
				    showbackground: true, zerolinecolor: '#444', automargin: true,
				    range: [-amax, amax] },
			   zaxis: { title: { text: 'Z' }, backgroundcolor: meas.plotBGColor, gridcolor: 'rgb(220, 220, 220)',
				    showbackground: true, zerolinecolor: '#444', automargin: true,
				    range: [-amax, amax] }
		       },
		       width: 450,
		       height: 450,
		       margin: {l:40, r:40, t:100, b:100, pad:4}
		     })
	    }

	    pelem.on('plotly_afterplot', function(ev) {
		meas.plottimes[cid] = (new Date()).getTime() - meas.plott0[cid]
	    })
	    // hole updates while manipulating graph
	    pelem.onmousedown = function(ev) {
		pelem.dataset.hold = true
	    }
	    pelem.onmouseup = function(ev) {
		pelem.dataset.hold = false
	    }
	    pelem.onmouseleave = function(ev) {
		pelem.dataset.hold = false
	    }
	})
	document.querySelector('#curmeas-plots').style['grid-template-columns'] = gtc
    }

    var ppFunc = function() {  ppFuncs.forEach(function(f) { f() })  }
    return {text: tds.join(''), done: ppFunc}
}

meas.psLiveMeasurement = function(data, el) {
    if (data.length>0 && data[0] == '<') {
	console.log('no CSV data')
	return
    }

    var ppFunc = function() {
//	console.log('live meas poll done')
    }

    var fname = el.dataset.fname
    meas.fname = fname

    if (el.dataset.headers == undefined) {
	meas.getMeasurementHeaders(fname, function() {
	    el.dataset.headers = 1
	})
	return {text: '', done: ppFunc}
    }

    var csv = data
    var arrayData = xc.readCSV(csv)
    if (String(arrayData[0][0]) == 'NaN') {
	arrayData = arrayData.map((k) => k.slice(1))
    }
    meas.data = arrayData
    meas.parseMeasurementArray(arrayData)

    meas.updateDisplay()

    return {text: '', done: ppFunc}
}

meas.onchangeLimitHead = function(target, event) {
    meas.loadDefaultBorders(function() {
	var selval = target.value
	if (!meas.defaultBorders) return
	var defBorders = meas.defaultBorders[selval]
	if (defBorders) {
	    target.form.elements.min.value = defBorders.min
	    target.form.elements.wmin.value = defBorders.wmin
	    target.form.elements.wmax.value = defBorders.wmax
	    target.form.elements.max.value = defBorders.max
	    target.form.elements.max.dataset.tdone = 0
	    target.form.elements.min.dataset.tdone = 0
	    target.form.elements.wmax.dataset.tdone = 0
	    target.form.elements.wmin.dataset.tdone = 0
	    tl.update(target.form)
	} else {
	    target.form.elements.min.value = ''
	    target.form.elements.wmin.value = ''
	    target.form.elements.wmax.value = ''
	    target.form.elements.max.value = ''
	}
    })
}

meas.psLimitSelector = function(data, el) {
    meas.processHeadline(data)

    var text = ''
    var getunit = (val)=> {
	val = val.split('_')[0]
	if (val == 'Acceleration') return 'g'
	else if (val == 'Rotation') return '°/s'
	else if (val == 'Temperature') return '°C'
    }
    text += '<label for="limit-head" class="tlt">Value</label>'
    text += '<select id="limit-head" name="head" onchange="meas.onchangeLimitHead(this, event)">'
    var opts = Object.keys(meas.headerInfo.names).map((k) => {
	var name = meas.headerInfo.names[k]
	var unit = meas.headerInfo.units[k]
	return '<option value="' + name + '">' + meas.translateMeasName(name).replace('_', ' ') + ' (' + getunit(name) + ')</option>'
    })
    text += opts.slice(1).join('')
    text += '</select>'

    return {text: text}
}

meas.psMultiField = function(data) {
    if (data.length == 0) return ''
    var items = data.split('\n')[1].split(' ')
    items = items.filter( (k) => k.length > 0 )
    return '<td class="tln">' + items.join('</td><td class="tln">') + '</td>'
}


meas.isNaN = function(v) {
    if (typeof v != 'number') {
	v = Number(v)
    }
    return (v + '') == 'NaN'
}

meas.onchangeLimit = function(event) {
    var limits = event.target.parentElement.querySelectorAll('.limit')
    var lvals = []
    limits.forEach((k) => {
	lvals.push(xc.number(k.value.replace(',', '.')))
    })
    Object.keys(lvals).forEach((k) => {
	var el = limits[k]
	var val = lvals[k]
	if (el.name.startsWith('w')) {
	    var min = lvals[0], max = lvals[3]
	    if (!meas.isNaN(min) && !meas.isNaN(max)) {
		if (meas.isNaN(val) || val < min || val > max) {
		    var range = max - min
		    var wmin = min + range*meas.warnRange
		    var wmax = max - range*meas.warnRange
		    if (el.name.startsWith('wmin')) {
			el.value = wmin
			el.dataset.tdone = ''
		    }
		    if (el.name.startsWith('wmax')) {
			el.value = wmax
			el.dataset.tdone = ''
		    }
		}
	    }
	}
    })
    tl.update()
}

meas.onchangeHandler = function(event) {
    var t = event.target
    if (t.classList.contains('limit')) {
	meas.onchangeLimit(event)
    }
}

document.addEventListener('change', meas.onchangeHandler)

meas.startFetch = function(ev) {
    //meas.curfetch = meas.note('Load' + ev.detail.url)
}

meas.endFetch = function(ev) {
    if (meas.curfetch) {
	meas.curfetch()
    }
}

document.addEventListener('xc-startfetch', meas.startFetch)
document.addEventListener('xc-endfetch', meas.endFetch)

tl.apptable({
    acc: { de: 'Beschleu&#xad;ni&#xad;gung', en: 'Acceleration'},
    gyro: {de: 'Gyro&#xad;skop', en: 'Gyroscope' },
    rot: {de: 'Ro&#xad;ta&#xad;tion', en: 'Rotation' },
    hum: {de: 'Feuch&#xad;tig&#xad;keit', en: 'Humidity' },
    mag: { de: 'Mag&#xad;net&#xad;feld', en: 'Magnetism'},
    pres: { de: 'Druck', en: 'Pressure'},
    temp: {de: 'Tem&#xad;pe&#xad;ra&#xad;tur', en: 'Temperature' },
    time: {de: 'Zeit', en: 'time' },
    timeC: {de: 'Zeit', en: 'Time' },
    co2: {de: 'CO<sub>2</sub>', en: 'CO<sub>2</sub>', C: 'CO2' },
    tvoc: {de: 'TVOC', en: 'TVOC' },

    d3dv: {de: 'Darstellung 3D-Werte', en: 'Display 3D values'},
    d3dg: {de: '3D-Werte graphisch darstellen', en: 'Graphic 3D value display'},
    upd: {de: 'Aktualisierung', en: 'Update'},
    lmv: {de: 'Aktuelle Messwerte', en: 'Latest Measurement Values'},
    mvp: {de: '3D-Komponenten projezieren', en: '3D component projection'},
    hsl: {de: 'Anzahl Daten', en: 'History length'},

    agg: {de: 'Gemeinsam', en: 'Aggregate'},
    sep: {de: 'Separat', en: 'Separate'},
    npr: {de: 'Nachkommastellen', en: 'Nummer precision'},

    mn1: {de: 'Messwerte', en: 'Measurements'},
    mn2: {de: 'Live-Anzeige', en: 'Live Graph'},
    mn3: {de: 'Steuerung', en: 'Control'},
    mn4: {de: 'Archiv', en: 'Archive'},
    mn5: {de: 'Einstellungen', en: 'Settings'},

    ms1: {de: 'Messeinstellungen', en: 'Measurement Settings'},
    ms2: {de: 'WiFi konfigurieren', en: 'Configure WiFi'},
    ms3: {de: 'Grenzen konfigurieren', en: 'Configure Limits'},

    resf: {de: 'Ergebnisdatei', en: 'Result file'},
    logf: {de: 'Logdatei', en: 'Log file'},

    mlv: {de: 'Messwerte Live-Anzeige', en: 'Measurement Live View'},
    mat: {de: 'Messwerte als Tabelle', en: 'Measurements as table'},

    mpc: {de: 'Messprozesssteuerung', en: 'Measurement Process Control'},
    cmd: {de: 'Befehlszeile', en: 'Command line'},
    std: {de: 'Gestartet', en: 'Started'},

    mem: {de: 'Speicher', en: 'Memory'},
    cpt: {de: 'CPU-Zeit', en: 'CPU time'},
    dur: {de: 'Dauer', en: 'Duration'},
    sta: {de: 'Zustand', en: 'State'},

    stam: {de: 'Messung starten', en: 'Start Measurement'},
    stom: {de: 'Messung stoppen', en: 'Stop Measurement'},
    shd1:  {de: 'uSense herunterfahren', en: 'Shut down uSense'},
    shd2:  {de: 'uSense neu starten', en: 'Restart uSense'},
    shd3:  {de: 'WiFi neu starten', en: 'Restart WiFi'},
    shd4:  {de: 'Test-E-Mail senden', en: 'Send test email'},
    shd5:  {de: 'Test-E-Mail', en: 'Test Email'},
    mor: {de: 'Mehr', en: 'More'},

    mar: {de: 'Messarchiv', en: 'Measurements Archive'},
    dld: {de: 'Herunterladen', en: 'Download'},
    ims: {de: 'Elemente', en: 'Items'},

    sif: {de: 'Werte in Ergebnisdatei', en: 'samples in measurement file'},
    bks: {de: 'Blockgröße', en: 'Block size'},
    dtr: {de: 'Datenbereich', en: 'Data range'},
    dlr: {de: 'Datenbereich herunterladen', en: 'Download data range'},

    del: {de: 'Löschen', en: 'Delete'},
    delm: {de: 'Ausgewählte löschen', en: 'Delete selected'},
    delp: {de: 'Dateiname', en: 'File name'},
    cwif: {de: 'Neues WiFi einrichten', en: 'Configure new WiFi setting'},
    wifs: {de: 'WiFi Einstellungen', en: 'WiFi Settings'},
    wifn: {de: 'WiFi Name (ESSID)', en: 'WiFi name (ESSID)'},
    wifp: {de: 'WiFi Passwort (PSK)', en: 'WiFi password (PSK)'},

    lim: {de: 'Grenzen', en: 'Limits'},
    lm1: {de: 'Warnungs- und Alarmgrenzen für Messwerte konfigurieren', en: 'Configure warning and alarm limits for measurement values'},
    lm2: {de: 'Neue Grenze konfigurieren', en: 'Configure new limit'},
    lm3: {de: 'Wert', en: 'Value'},
    lm4: {de: 'Grenzeinstellungen', en: 'Limit settings'},
    lm5: {de: 'Grenzen für', en: 'Limits for'},
    lm6: {de: 'Untere Warnschwelle', en: 'Lower warning level'},
    lm7: {de: 'Obere Warnschwelle', en: 'Upper warning level'},

    es1: {de: 'E-Mail Einstellungen', en: 'Email Settings'},
    es2: {de: 'E-Mail konfigurieren', en: 'Configure Email'},
    es3: {de: 'E-Mail Absende-Adresse', en: 'From Email'},
    es4: {de: 'E-Mail Server-Adresse', en: 'Email host'},
    es5: {de: 'E-Mail Nutzername', en: 'Email user'},
    es6: {de: 'E-Mail Passwort', en: 'Email password'},
    es7: {de: 'E-Mail Verschlüsselung', en: 'Email encryption'},
    es8: {de: 'Keine', en: 'None'},
    es9: {de: 'SSL', en: 'SSL'},
    esa: {de: 'TLS', en: 'TLS'},
    esb: {de: 'E-Mail-Einstellungen konfigurieren', en: 'Configure Email settings'},
    esc: {de: 'E-Mail Empfänger', en: 'Email recipients'},
    esd: {de: 'E-Mail Server-Port', en: 'Email port'},
    ese: {de: 'Empfänger', en: 'Recipient'},
    esf: {de: 'Neue Empfängeradresse', en: 'New recipient address'},

    st1: {de: 'Sensoren', en: 'Sensors'},
    st2: {de: 'Gas- und Partikelsensoren', en: 'Gas and particles sensor'},
    st3: {de: 'Magnetometer', en: 'Magnetometer'},
    st4: {de: 'Beschleunigungssensor und Gyroskop', en: 'Accelerometer and Gyroscope'},
    st4a: {de: 'Beschleunigungssensor', en: 'Accelerometer'},
    st5: {de: 'Temperatur-, Druck- und Feuchtigkeitssensoren', en: 'Temperature, pressure and humidity sensors'},
    st6: {de: 'Messprogramm', en: 'Measurement program'},
    st7: {de: 'Messinterval', en: 'Measurement interval'},
    st8: {de: 'Messinterval in Sekunden', en: 'Measurement interval in seconds'},

    op1: {de: 'main.py - Standardprogramm', en: 'main.py - Standard program'},
    op2: {de: 'mainicm.py - Standardprogramm', en: 'mainicm.py - Standard program'},
    op3: {de: 'main-dummy.py - Generiert Zufallsdaten', en: 'main-dummy.py - Generates random data'},

    lm1a: {de: 'Daten', en: 'Data'},
    lm2a: {de: 'Grenzen', en: 'Limits'},
    lm3a: {de: 'Fehler-Grenzen', en: 'Error-Limits'},
    lm4a: {de: 'Warn-Grenzen', en: 'Warn-Limits'},
    lm5a: {de: 'Y-Achsgrenzen nach', en: 'Y axis ranges by'},

    sts1: {de: 'Gerätestatus', en: 'Device status'},
    sts2: {de: 'WiFi-Status', en: 'WiFi status'},
    sts3: {de: 'Festplattenstatus', en: 'Disk status'},
    sts4: {de: 'Netzwerkstatus', en: 'Network status'},

    scolh1: {de: 'Name', en: 'Name'},
    scolh2: {de: 'Datum', en: 'Date'},
    scolh3: {de: 'Größe', en: 'Size'},

    fh1: {de: 'Bitte bestätigen', en: 'Please confirm'},
    fh2: {de: 'Löschen', en: 'Delete'},

    uuc1: {de: 'Aktualisierungssteuerung', en: 'Update Control'},
    uuc2: {de: 'Aktualisiere Paketlisten', en: 'Scan for Updates'},
    uuc3: {de: 'Aktualisiere uSense Pakete', en: 'Update uSense packages'},
    uuc4: {de: 'Aktualisiere Systempakete', en: 'Update system packages'},
    uuc5: {de: 'Aktualisiere uSense Paketeliste', en: 'Scan for updates of uSense packages'},
    uuc6: {de: 'Aktualisiere Systempaketliste', en: 'Scan for updates of system packages'},
    uuc6a: {de: 'Gerätesteuerung', en: 'Device Control'},
    uuc7: {de: 'Logdatei', en: 'Log file'},
    uuc8: {de: 'Tabelle', en: 'Table'},
    uuc9: {de: 'uSense Pakete', en: 'uSense Packages'},
    uuc10: {de: 'Aktualisierbare Systempakete', en: 'Upgradable System Packages'},
    uuc11: {de: 'Datei', en: 'File'},
    uuc12: {de: 'Anzeigen', en: 'Show'},
    uuc13: {de: 'Aktualisieren', en: 'Upgrade'},

    stn1: {de: 'Messfrequenz', en: 'Sample rate'},
    stn2: {de: 'Messbereich', en: 'Measurement range'},
    stn3: {de: 'Einheit', en: 'Unit'},
    stn4: {de: 'Filter', en: 'Filter'},
    stn5: {de: 'Tiefpass-Filter', en: 'Low-pass filter'},
    stn6: {de: 'Bandbreite', en: 'Band width'},
    stn7: {de: 'Einzelwerte', en: 'Single values'},
    stn8: {de: 'Bandsperre', en: 'Notch filter'},
    stn9: {de: 'Antialiasing', en: 'Anti-aliasing'},
    stn10: {de: 'Antialiasing-Filter', en: 'Anti-aliasing filter'},
    stn11: {de: 'Versatz', en: 'Offset'},
    stn12: {de: 'Mittenfrequenz', en: 'Center frequency'},
    stn13: {de: 'Aktivieren', en: 'Enable'},
    stn14: {de: 'Ordnung', en: 'Order'},
    stn15: {de: 'Niedrige Latenz', en: 'Low latency'},
    stn16: {de: 'Volle Auflösung', en: 'Full precision'},
    stn17: {de: 'Auflösung', en: 'Resolution'},
    stn18: {de: 'X', en: 'X'},
    stn19: {de: 'Y', en: 'Y'},
    stn20: {de: 'Z', en: 'Z'},
    stn21: {de: 'Eff. Messfrequenz', en: 'Eff. sample rate'},
    stn22: {de: 'Datenrate', en: 'Data rate'},
    stn23: {de: 'Werten', en: 'values'},
    stn24: {de: 'Ausgabe: 1 von', en: 'Output 1 of'},
    stn25: {de: 'Eff. Bandbreite', en: 'Eff. bandwidth'},
    stn26: {de: 'Holen', en: 'Fetch'},
    stn27: {de: 'Frei lassen für Werkseinstellungen, oder', en: 'Leave blank to use factory trimmed parameters, or'},
    stn28: {de: 'vom Sensor', en: 'from sensor'},
    stn29: {de: 'Erweitert', en: 'Advanced'},
    stn30: {de: 'Ereignis beended', en: 'Event ended'},
    stn31: {de: 'Schließen', en: 'Close'},
    stn32: {de: 'Aktualisieren', en: 'Reload'},
    stn33: {de: 'Kalibrieren', en: 'Calibrate'},
    stn34: {de: 'der Gyroskop Versatzwerte', en: 'gyroscope offsets'},
    stn35: {de: 'Achsen invertieren', en: 'Invert Axes'},
    stn36: {de: 'Keine Ereignisse', en: 'No events'},
    stn37: {de: 'Liste der Grenzereignisse', en: 'List of limit events'},

    osr1:  {de: 'Messfrequenz/2',  en: 'Sample rate/2'},
    osr2:  {de: 'Messfrequenz/4',  en: 'Sample rate/4'},
    osr3:  {de: 'Messfrequenz/5',  en: 'Sample rate/5'},
    osr4:  {de: 'Messfrequenz/8',  en: 'Sample rate/8'},
    osr5:  {de: 'Messfrequenz/10', en: 'Sample rate/10'},
    osr6:  {de: 'Messfrequenz/16', en: 'Sample rate/16'},
    osr7:  {de: 'Messfrequenz/20', en: 'Sample rate/20'},
    osr8:  {de: 'Messfrequenz/40', en: 'Sample rate/40'},

    btn1: {de: 'Speichern', en: 'Save'},
})

tl.setCurrentLanguage(navigator.language)

meas.showCSV = function(text) {
    if (text.length == 0) {
	return {noupdate: true}
    }
    var lines = text.split('\n')
    if (lines[lines.length -1].length == 0) {
	lines = lines.slice(0, -1)
    }
    var rows = lines.map((ln)=> {
	return ln.split(';')
    })

    var theader = '<tr><th>' + rows[0].join('</th><th>') + '</th></tr>'
    var trows = rows.slice(1).map((items)=> {
	return '<tr><td>' + items.join('</td><td>') + '</td></tr>'
    })

    var table = '<table class="xc-csv xc-table"><thead>' + theader + '</thead><tbody>' + trows.join('\n') + '</tbody></table>'

    return table
}

meas.psEventListInner = function(text) {
    if (text.length == 0) {
	return '<span class="tlt">No events</span>'
    }

    var classes = [ 'alarm-low', 'warn-low', 'ok-low', 'warn-high', 'alarm-high' ]
    var tmap = (t)=> {
	return classes[t+2]
    }

    var items = text.split('\n')
    items = items.slice(0, -1)

    if (items.length == 0) {
	return '<span class="tlt">No events</span>'
    }

    var elems = items.map((x)=> x.split(';')).reverse()

//    var eHeader = elems[0]
//    elems = elems.slice(1)

    var prows = elems.map((fields)=> {
	fields[1] = JSON.parse(fields[1])
	return fields
    })

//    var prows = prows.filter((fields)=> fields[1].length > 0)

    var rows = prows.map((fields)=> {
	var ts = new Date(fields[0]*1000).toLocaleString()
	var evData = fields[1]
	var evclass = 'event'
	var res = ''
	if (evData.length>0) {
	    for (var i = 0; i < evData.length; ++i) {
		var s = ''
		if (i == 0) {
		    s += '<td class="ts">' + ts + '</td>'
		} else {
		    s += '<td/>'
		}
		var unit = meas.getUnit(evData[i].source, meas.events.headerInfo)
		s += '<td>' + meas.translateMeasName(evData[i].source).replace('_', ' ') + '</td>'
		s += '<td class="' + tmap(evData[i].type) + '"><span title="' + evData[i].value + ' ' + unit + '" class="tln">' + evData[i].value + '</span> <span class="unit">' + unit + '</span></td>'
		//	s += '<td class="' + tmap(evData.type) + '">&nbsp;</td>'
		res += '<tr class="event">' + s + '</tr>'
	    }
	} else {
	    var s = '<td class="ts">' + ts + '</td>'
	    s += '<td class="tlt">Event ended</td><td></td>'
	    res = '<tr class="noevent">' + s + '</tr>'
	}
	return res
    })

    var tbl = '<table>' + rows.join('\n') + '</table>'
    return tbl
}

meas.psEventList = function(text) {
    var inner = meas.psEventListInner(text)
    var html = '<div class="events dynsec">'
    html += '<h4 class="tlt">List of limit events</h4>'
    html += '<div><a class="xc-nocatch floatr tlt" href="#" onclick="meas.updateEventsList(event)">Reload</a> '
    html += '<a class="xc-nocatch floatr tlt" href="#" onclick="meas.closeDynamicSection(event)">Close</a></div>'
    html += '<div>' + inner + '</div>'
    html += '</div>'
    return html
}

meas.events = { range: [0, 4000], fname: '' }

meas.inject = function(id, html, ev, done) {
    var target = document.querySelector('#' + id)
    xc.inject(id, html)
    updateTreeFinal(target, ev, function(a,b) {
	done(a, b)
    })
}

meas.hideResultView = function() {
    meas.hideChildren('.charts')
    document.querySelector('#result-dispsels').innerHTML = ''
    document.querySelector('#result-nmeas').innerHTML = ''
}

meas.updateEventsList = function(ev) {
    var fname = meas.events.fname
    meas.hideResultView()
    xlp.sendGet('/main/range?path=' + fname + '&start=' + meas.events.range[0] + '&end=' + meas.events.range[1], function(s, resp) {
	if (s != 0) { return }
	xlp.sendGet('/main/head?path=' + meas.events.measname + '&n=1', function(s, respH) {
	    if (s != 0) { return }
	    meas.events.headers = meas.parseMeasurementHeaders(respH.responseText)
	    meas.events.headerInfo = meas.partitionMeasurementHeaders(meas.events.headers)

	    var html = meas.psEventList(resp.responseText)
	    meas.inject('event-view', html, ev, function(a,b) {
		console.log('Events list updated')
		window.scrollTo(0,100)
	    })
	})
    })
}

meas.loadEvents = function(fname, ev) {
    meas.events.fname = fname
    meas.events.measname = fname.split('-events').join('')
    meas.updateEventsList(ev)
}

meas.findAncestorByClass = function(x, cname) {
    if (x.classList.contains(cname)) {
	return x
    } else if (x.parentElement) {
	return meas.findAncestorByClass(x.parentElement, cname)
    }
}

meas.closeDynamicSection = function(event) {
    var x = event.target
    var ctarget = x.parentElement
    if (x.dataset.target) {
	ctarget = document.querySelector('#' + x.dataset.target)
    } else {
	var ct2 = meas.findAncestorByClass(x, 'dynsec')
	if (ct2) {
	    ctarget = ct2
	}
    }
    ctarget.innerHTML = ''
}

meas.measListSelectAll = function(ev) {
    var form = document.forms['deleteitems']
    var x = ev.target
    for (var i = 0; i < form.elements.length; ++i) {
	form.elements[i].checked = x.checked
    }
}
