#! /bin/bash

settingf=$1

if ! iim42652-tool --connected; then
    echo "Device not found"
    exit
fi

echo "<sensor-config>" > /tmp/sensorsettings.xml

awk -F= '{ print " <value name=\"" $1 "\">" $2 "</value>" }' $settingf >> /tmp/sensorsettings.xml

echo "</sensor-config>" >> /tmp/sensorsettings.xml

xsltproc --stringparam curvals-uri /tmp/sensorsettings.xml -o /tmp/settings-updated.xml files/xsl/inject-sensor-settings.xsl settings.xml 
if [[ "$?" != "0" ]]; then
    echo "failed to transform"
    cat /tmp/sensorsettings.xml
    exit
fi

cat /tmp/sensorsettings.xml
rm /tmp/sensorsettings.xml
diff /tmp/settings-updated.xml settings.xml
cp /tmp/settings-updated.xml settings.xml
rm /tmp/settings-updated.xml
