#! /bin/bash

set -x

mode=$1

mydir=$(readlink -f $(dirname $BASH_SOURCE))

export XC_WORKDIR=$(readlink -f $mydir/..)

# Config variables
program=icm20640-fifo-mp

# Config from file
source $mydir/../etc/sensorsettings.conf

if [[ -z "$program" ]]; then
    program=icm20640-fifo-mp
fi

umprog=$program

measdir=measurements

dstr=$(date +"%Y-%m-%dT%H%M%S")
ofname=$measdir/calibration-${dstr}.csv
ofnames=$measdir/calibration-${dstr}-slow.csv
ofnamee=$measdir/calibration-${dstr}-events.csv

$umprog -c $XC_WORKDIR/etc/sensorsettings.ini \
	--maxreadt=3 --odr=1000 --fifo-packet=4 --fdr-sel=1 --downsample-rate=1 \
	--gyro-offset-x=0 --gyro-offset-y=0 --gyro-offset-z=0 \
	--accel-offset-x=0 --accel-offset-y=0 --accel-offset-z=0 \
	--gyro-factor-x=-1 --gyro-factor-y=-1 --gyro-factor-z=-1 \
	--accel-factor-x=-1 --accel-factor-y=-1 --accel-factor-z=-1 \
	--outfile=$ofname --downsample-outfile=$ofnames --events-outfile=$ofnamee

sed -n '2{p;q}' $ofnames > calib.txt

cat calib.txt

echo -n "" > calib.set

case $mode in
    (*gyro*)
	awk -F ';' '{ print "gyroOffsetX="$14; print "gyroOffsetY="$17; print "gyroOffsetZ="$20; }' calib.txt >> calib.set
	;;
esac
case $mode in
    (*accel*)
	awk -F ';' '{ print "accelOffsetX="$5; print "accelOffsetY="$8; print "accelOffsetZ="$11; }' calib.txt      >> calib.set
	;;
esac

cat calib.set
