#! /bin/bash

mydir=$(readlink -f $(dirname $BASH_SOURCE))

export XC_WORKDIR=$(readlink -f $mydir/..)

rpid=$1

if [[ -z "$rpid" ]]; then
    if [[ -f $XC_WORKDIR/measurement.pid ]]; then
	rpid=$(cat $XC_WORKDIR/measurement.pid)
    else
	echo "no measurement running" 1>&2
	echo "<pids xmlns='http://ai-and-it.de/xmlns/2020/xc'/>"
	exit
    fi
fi

pids=$(pstree -a -T -p $rpid | cut -d, -f2 | cut -d ' ' -f1)
pidsxml="<pids xmlns='http://ai-and-it.de/xmlns/2020/xc'>"
for spid in ${pids[@]}; do
    pidsxml="$pidsxml<pid>$spid</pid>"
done
pidsxml="$pidsxml</pids>"

echo "$pidsxml"

exit 0
