#! /bin/bash

fields="$@"

if ! iim42652-tool --connected; then
    echo "Device not found"
    exit
fi

iim42652-tool $fields > /tmp/sensorsettings.txt
if [[ "$?" != "0" ]]; then
    echo "failed to fetch"
    cat /tmp/sensorsettings.txt
    exit
fi

echo "<sensor-config>" > /tmp/sensorsettings.xml

awk '{ print " <value name=\"" $1 "\">" $3 "</value>" }' /tmp/sensorsettings.txt >> /tmp/sensorsettings.xml

echo "</sensor-config>" >> /tmp/sensorsettings.xml

rm /tmp/sensorsettings.txt

#cat /tmp/sensorsettings.xml

xsltproc --stringparam curvals-uri /tmp/sensorsettings.xml -o /tmp/settings-updated.xml files/xsl/inject-sensor-settings.xsl settings.xml 
if [[ "$?" != "0" ]]; then
    echo "failed to transform"
    cat /tmp/sensorsettings.xml
    exit
fi

cat /tmp/sensorsettings.xml
rm /tmp/sensorsettings.xml
cp /tmp/settings-updated.xml settings.xml
rm /tmp/settings-updated.xml
