<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns="http://www.w3.org/1999/xhtml"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="text()"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="x:title" mode="title">
    <h4 class="tlt"><xsl:value-of select="."/></h4>
  </xsl:template>
  <xsl:template match="x:title"/>

  <xsl:template match="x:update">
    <div>
      <h2><span class="tlt">Update Control</span></h2>

      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="x:update-control">
    <div class="update-controls">
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="x:upgrades">
    <div class="upgrade-controls" style="grid-column: 1/span 2;">
      <fieldset style="display: grid; grid-template-columns: auto auto;">
	<legend style="grid-column: 1/ span 2;" class="tlt">Upgrade</legend>
	<xsl:apply-templates/>
      </fieldset>
    </div>
  </xsl:template>

  <xsl:template match="x:scan-updates">
    <div class="scan-updates flexv">
	<form class="inline-block" action="/main/action" method="post">
	  <input type="hidden" name="path" value="bin/fetch-updates.sh"/>
	  <input class="tltv" type="submit" value="Scan for Updates"/>
	  <input type="hidden" name="next_" value="/main/ajax_view?path=update.xml"/>
	  <input type="hidden" name="csrfmiddlewaretoken" value="{//*/x:cgi/x:csrfmiddlewaretoken}"/>
	  <input type="hidden" name="nowait" value="1"/>
	</form>
    </div>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="x:usense-upgrade">
    <div class="upgrade flexv">
      <form class="inline-block" action="/main/action" method="post">
	<input type="hidden" name="path" value="bin/upgrade-usense.sh"/>
	<input class="tltv" type="submit" value="Update uSense packages"/>
	<input type="hidden" name="next_" value="/main/ajax_view?path=update.xml"/>
	<input type="hidden" name="csrfmiddlewaretoken" value="{//*/x:cgi/x:csrfmiddlewaretoken}"/>
	<input type="hidden" name="nowait" value="1"/>
      </form>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="x:upgrade">
    <div class="upgrade flexv">
      <form class="inline-block" action="/main/action" method="post">
	<input type="hidden" name="path" value="bin/upgrade.sh"/>
	<input class="tltv" type="submit" value="Update system packages"/>
	<input type="hidden" name="next_" value="/main/ajax_view?path=update.xml"/>
	<input type="hidden" name="csrfmiddlewaretoken" value="{//*/x:cgi/x:csrfmiddlewaretoken}"/>
	<input type="hidden" name="nowait" value="1"/>
      </form>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="x:full-upgrade">
    <div class="flexv">
      <form class="inline-block" action="/main/action" method="post">
	<input type="hidden" name="path" value="bin/upgrade-full.sh"/>
	<input class="tltv" type="submit" value="Full-update uSense packages"/>
	<input type="hidden" name="next_" value="/main/ajax_view?path=update.xml"/>
	<input type="hidden" name="csrfmiddlewaretoken" value="{//*/x:cgi/x:csrfmiddlewaretoken}"/>
	<input type="hidden" name="nowait" value="1"/>
      </form>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="x:log">
    <div style="grid-column: 1/ span 2;" class="log update-log">
      <div class="log-file">
	<span class="tlt">Log file</span>
	<xsl:text> </xsl:text>
	<a class="xc-nocatch" href="/main/getf/{.}"><xsl:value-of select="."/></a>
      </div>
      <div class="log-text">
	<code class="xc-sl-poll pre oneline"
	      data-poll-url="/main/tail?path={.}&amp;n=1"
	      data-postprocess="psText"
	      data-poll-interval="500">
	</code>
      </div>
    </div>
  </xsl:template>

  <xsl:template match="x:table">
    <div class="csvtab">
      <xsl:apply-templates select="x:title" mode="title"/>
      <div class="csvtab-file">
	<span class="tlt">File</span>
	<span><xsl:text>: </xsl:text></span>
	<a class="xc-nocatch" href="/main/getf/{x:file}"><xsl:value-of select="x:file"/></a>
      </div>
      <div class="xc-sl-poll csvtab-content" data-poll-url="/main/get?path={x:file}"
	   data-postprocess="meas.showCSV"
	   data-poll-interval="500">
      </div>
    </div>
  </xsl:template>

  <xsl:template match="x:long-table">
    <div class="csvtab">
      <xsl:apply-templates select="x:title" mode="title"/>
      <div class="csvtab-file">
	<span class="tlt">File</span>
	<span><xsl:text>: </xsl:text></span>
	<a class="xc-nocatch" href="/main/getf/{x:file}"><xsl:value-of select="x:file"/></a>
      </div>
      <div class="csvtab-oc oc-wrap">
	<button class="oc-head tlt">Show</button>
	<div class="oc-body xc-sl-poll csvtab-content" data-poll-url="/main/get?path={x:file}"
	     data-postprocess="meas.showCSV"
	     data-poll-interval="500">
	</div>
      </div>
    </div>
  </xsl:template>

</xsl:stylesheet>
