<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns="http://ai-and-it.de/xmlns/2020/xc"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8" indent="yes"/>

  <xsl:template match="text()"/>

  <xsl:template match="/">
    <email-settings>
      <xsl:apply-templates/>
      <testemail>
	<log>send-testemail.log</log>
      </testemail>
    </email-settings>
  </xsl:template>

  <xsl:template match="x:cgi">
    <from>
      <xsl:value-of select="x:email-from"/>
    </from>
    <host>
      <xsl:value-of select="x:email-host"/>
    </host>
    <port>
      <xsl:value-of select="x:email-port"/>
    </port>
    <user>
      <xsl:value-of select="x:email-user"/>
    </user>
    <pass>
      <xsl:value-of select="x:email-pass"/>
    </pass>
    <enc>
      <xsl:value-of select="x:email-enc"/>
    </enc>
    <xsl:for-each select="x:*[starts-with(local-name(), 'email-to')]">
      <xsl:variable name="del-node" select="concat('del-', local-name(current()))"/>
      <xsl:if test="not(../x:*[local-name() = $del-node])">
	<to><xsl:value-of select="."/></to>
      </xsl:if>
    </xsl:for-each>
    <xsl:for-each select="x:*[starts-with(local-name(), 'new-email-to')]">
      <xsl:if test="string-length(.)>0">
	<to><xsl:value-of select="."/></to>
      </xsl:if>
    </xsl:for-each>

  </xsl:template>

</xsl:stylesheet>
