<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  version="1.0">

  <xsl:output method="text" encoding="utf-8" indent="yes"/>

  <xsl:template match="text()"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="x:email-settings">

DEFAULT_FROM_EMAIL = '<xsl:value-of select="x:from"/>'
EMAIL_RECIPIENTS = [
<xsl:for-each select="x:to">
  '<xsl:value-of select="."/>',
</xsl:for-each>
]

EMAIL_HOST = '<xsl:value-of select="x:host"/>'
<xsl:if test="string(number(x:port)) != 'NaN'">
EMAIL_PORT = <xsl:value-of select="string(number(x:port))"/>
</xsl:if>

EMAIL_HOST_USER = '<xsl:value-of select="x:user"/>'
EMAIL_HOST_PASSWORD = '<xsl:value-of select="x:pass"/>'

<xsl:choose>
  <xsl:when test="x:enc = 'ssl'">
EMAIL_USE_SSL = True
  </xsl:when>
  <xsl:when test="x:enc = 'tls'">
EMAIL_USE_TLS = True
  </xsl:when>
</xsl:choose>

<xsl:text>
</xsl:text>

  </xsl:template>
  
</xsl:stylesheet>
