<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns="http://ai-and-it.de/xmlns/2020/xc"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8" omit-xml-declaration="yes"/>

  <xsl:param name="curvals-uri"/>
  <xsl:param name="curvals" select="document($curvals-uri)"/>
  
  <xsl:template match="/">
    <xsl:if test="not($curvals/*)">
      <xsl:message terminate="yes">
	current settings doc "<xsl:value-of select="$curvals-uri"/>" not loaded
      </xsl:message>
    </xsl:if>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="*">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="x:gyro/x:notch-filter/x:bandwidth/x:value">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:variable name="value" select="number($curvals/*/value[@name = 'gyroNfilterBw'])"/>
      <xsl:choose>
	<xsl:when test="$value"><xsl:value-of select="$value"/></xsl:when>
	<xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="x:gyro/x:notch-filter/x:center/x:value">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:variable name="value" select="floor($curvals/*/value[@name = concat('gyroNfilterCenter', current()/../x:axis)])"/>
      <xsl:choose>
	<xsl:when test="$value"><xsl:value-of select="$value"/></xsl:when>
	<xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="x:gyro/x:aa-filter/x:bandwidth/x:value">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:variable name="value" select="number($curvals/*/value[@name = 'gyroAAFilter3dBBW'])"/>
      <xsl:choose>
	<xsl:when test="$value"><xsl:value-of select="$value"/></xsl:when>
	<xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="x:accel/x:aa-filter/x:bandwidth/x:value">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:variable name="value" select="number($curvals/*/value[@name = 'accelAAFilter3dBBW'])"/>
      <xsl:choose>
	<xsl:when test="$value"><xsl:value-of select="$value"/></xsl:when>
	<xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="x:gyro/x:offset/x:value">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:variable name="value" select="$curvals/*/value[@name = concat('gyroOffset', current()/../x:axis)]"/>
      <xsl:choose>
	<xsl:when test="$value"><xsl:value-of select="$value"/></xsl:when>
	<xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="x:accel/x:offset/x:value">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:variable name="value" select="$curvals/*/value[@name = concat('accelOffset', current()/../x:axis)]"/>
      <xsl:choose>
	<xsl:when test="$value"><xsl:value-of select="$value"/></xsl:when>
	<xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="x:gyro/x:filter/x:low-latency">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:variable name="value" select="$curvals/*/value[@name = 'gyroUifilterLowLatency']"/>
      <xsl:choose>
	<xsl:when test="$value"><xsl:value-of select="$value"/></xsl:when>
	<xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="x:gyro/x:filter/x:order/x:value">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:variable name="value" select="number($curvals/*/value[@name = 'gyroUifilterOrder'])"/>
      <xsl:choose>
	<xsl:when test="$value"><xsl:value-of select="$value"/></xsl:when>
	<xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="x:gyro/x:filter/x:bandwidth/x:value">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:variable name="value" select="$curvals/*/value[@name = 'gyroUifilter3dBBW']"/>
      <xsl:choose>
	<xsl:when test="$value"><xsl:value-of select="$value"/></xsl:when>
	<xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="x:accel/x:filter/x:low-latency">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:variable name="value" select="$curvals/*/value[@name = 'accelUifilterLowLatency']"/>
      <xsl:choose>
	<xsl:when test="$value"><xsl:value-of select="$value"/></xsl:when>
	<xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="x:accel/x:filter/x:order/x:value">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:variable name="value" select="number($curvals/*/value[@name = 'accelUifilterOrder'])"/>
      <xsl:choose>
	<xsl:when test="$value"><xsl:value-of select="$value"/></xsl:when>
	<xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="x:accel/x:filter/x:bandwidth/x:value">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:variable name="value" select="$curvals/*/value[@name = 'accelUifilter3dBBW']"/>
      <xsl:choose>
	<xsl:when test="$value"><xsl:value-of select="$value"/></xsl:when>
	<xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
