<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns="http://www.w3.org/1999/xhtml"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="text()"/>

  <xsl:template match="/">
    <div>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="text()" mode="xml-dump">
    <span>
      <xsl:value-of select="."/>
    </span>
  </xsl:template>

  <xsl:template match="*" mode="xml-dump">
    <xsl:text>&lt;</xsl:text>
    <xsl:text>{</xsl:text>
    <xsl:value-of select="namespace-uri()"/>
    <xsl:text>}:</xsl:text>
    <xsl:value-of select="name()"/>
    <xsl:text> </xsl:text>
    <xsl:for-each select="@*">
      <xsl:value-of select="name()"/>
      <xsl:text>="</xsl:text>
      <xsl:value-of select="."/>
      <xsl:text>"</xsl:text>
    </xsl:for-each>
    <xsl:text>&gt;</xsl:text>
    <xsl:apply-templates mode="xml-dump"/>
    <xsl:text>&lt;/</xsl:text>
    <xsl:value-of select="name()"/>
    <xsl:text>&gt;</xsl:text>
  </xsl:template>

  <xsl:template match="x:dict">
    <div>
      DEFAULT VIEW
      <code>
	<xsl:apply-templates select="." mode="xml-dump"/>
      </code>
    </div>
  </xsl:template>

  <xsl:template match="x:dict[x:view = 'dirmanform']">
    <div>
      <xsl:apply-templates select="../x:forms/x:form[1]" mode="print-form"/>
    </div>
  </xsl:template>

  <xsl:template match="x:*" mode="form-hint">
    <span class="tlt"><xsl:text>Please confirm</xsl:text></span>
  </xsl:template>

  <xsl:template match="x:*" mode="print-form">
    <xsl:element name="{local-name()}">
      <xsl:copy-of select="@*"/>
      <fieldset>
	<legend class="tlt"><xsl:value-of select="@title"/></legend>
	<p>
	  <xsl:apply-templates select="." mode="form-hint"/>
	</p>
	<xsl:for-each select="x:field/x:*">
	  <xsl:if test="@name != 'comment'">
	    <xsl:apply-templates select="." mode="to-xhtml"/>
	    <br/>
	  </xsl:if>
	</xsl:for-each>
	<br/>
	<input type="submit" class="tltv" value="{@title}"/>
	<xsl:apply-templates select="//x:xc/x:csrf/x:input" mode="to-xhtml"/>
      </fieldset>
    </xsl:element>
  </xsl:template>

  <xsl:template match="x:*" mode="to-xhtml">
    <xsl:element name="{local-name()}">
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates mode="to-xhtml"/>
    </xsl:element>
  </xsl:template>

</xsl:stylesheet>
