#! /usr/bin/env python3

from xc.dirman.dirman import *
import ilff
import os

version = 'ILFF Dirman 1.0'

class DirManager(DirManager):

    version = 'ILFF DirManager 1.0'

    def __init__(self, base='.'):
        super().__init__(base=base)

    def getlines(self, name, offs=0, ln=-1):
        file = ilff.ILFFGetLines(self.getpath(name), 'r')
        # print('File read lines: %s, %d, %d' % (name, offs, ln))
        t0 = time.time()
        lines = ''
        if offs < 0:
            offs = 0
        nln = file.get_nlines()
        if offs + ln > nln:
            ln = nln - offs
        try:
            lines = file.getlinestxt(offs, ln)
        except BaseException as e:
            print(e)
            print('File line read failed: %s, %d, %d: %s (PID %d)' % (name, offs, ln, e, os.getpid()))
        t1 = time.time()
        # print('File lines read: %s, %d, %d: %d, %g s' % (name, offs, ln, len(lines.split('\n')), t1 - t0))
        return lines

    def nlines(self, name):
        return ilff.ILFFGetLines(self.getpath(name), 'r').get_nlines()


class GitDirManager(DirManager):

    def __init__(self, base='.'):
        super.__init__(base=base)
