#! /bin/bash

set -x

logfile=${2:-measurement.log}

exec >> $logfile
exec 2>&1

pidfile=${1:-measurement.pid}

if ! [[ -f "$pidfile" ]]; then
    echo "PID file $pidfile not found, process probably not running"
    exit 1
fi

PID=$(cat $pidfile)

kill $PID

for i in {1..10}; do
    if s=`ps -p $PID -o s=` && [[ -n "$s" && "$s" != 'Z' ]]; then
	:
    else
	break
    fi
    sleep 1
done
if s=`ps -p $PID -o s=` && [[ -n "$s" && "$s" != 'Z' ]]; then
    kill -9 $PID
fi

echo "Stop measurement process $PID"

rm $pidfile

exit 0
