<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns="http://www.w3.org/1999/xhtml"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="text()"/>

  <xsl:template match="/">
    <div>
      <div class="xc-sl-view"
	   data-view-url="/main/get/files/xml/mainmenu.xml"
	   data-view-cache="1"
	   data-view-filter="xc.psHTMLC">
      </div>
      <h2 class="tlt">Settings</h2>
      <div class="xc-sl-view"
	   data-view-url="/main/get/files/xml/settings-submenu.xml"
	   data-view-cache="1"
	   data-view-filter="xc.psHTMLC">
      </div>
      <h2 class="tlt">WiFi Settings</h2>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="x:wifi-settings">
    <div class="um-wifi-settings">
      <form action="javascript:meas.submitWiFiSettings" method="post">
	<fieldset>
	  <legend class="tlt">Configure new WiFi setting</legend>
	  <label for="wifi-essid" class="tlt">WiFi name (ESSID)</label>
	  <input id="wifi-essid" type="text" name="essid"/>
	  <label for="wifi-psk" class="tlt">WiFi password (PSK)</label>
	  <input id="wifi-psk" type="password" name="psk"/>
	</fieldset>

<!--	<h2 class="tlt">WiFi Settings</h2> -->
	<xsl:apply-templates/>

	<input type="hidden" name="path" value="settings.xml"/>
	<input type="hidden" name="data"/>
	<input type="hidden" name="next_" value="/main/ajax_view?path=wifi-settings.xml"/>
	<input type="hidden" name="csrfmiddlewaretoken"/>
	<input class="tltv" type="submit" value="Save"/>
      </form>
    </div>
    <div class="flexv">
      <form class="inline-block" action="/main/action" method="post">
	<fieldset>
	  <legend class="tlt">Restart WiFi</legend>

	  <code class="xc-sl-poll pre mono" data-poll-url="/main/plain_status?path=bin/iwconfig.sh"
		data-postprocess="xc.psHead(2)"
		id="status-iwconfig"
		data-poll-interval="1000">
	  </code>

	  <input type="hidden" name="path" value="bin/restart-wifi.sh"/>
	  <input class="tltv" type="submit" value="Restart WiFi"/>
	  <input type="hidden" name="next_" value="/main/ajax_view?path=wifi-settings.xml"/>
	  <input type="hidden" name="csrfmiddlewaretoken" value="{//*/x:cgi/x:csrfmiddlewaretoken}"/>

	</fieldset>
      </form>
    </div>
  </xsl:template>

  <xsl:template match="x:wifi">
    <fieldset>
      <legend>WiFi <xsl:value-of select="x:essid"/></legend>
      <label for="wifi-delete" class="tlt">Delete</label>
      <input id="wifi-delete" type="checkbox" name="delete-{x:essid}"/>
    </fieldset>
  </xsl:template>
  
</xsl:stylesheet>
