<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns="http://ai-and-it.de/xmlns/2020/xc"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="/">
    <!-- update! -->
    <xsl:comment>Update!</xsl:comment>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="x:wifi-settings-update">
    <xsl:apply-templates select="descendant-or-self::x:wifi-settings"/>
  </xsl:template>

  <xsl:template match="*">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="x:wifi-settings">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates/>
      <xsl:variable name="new-essid">
	<xsl:value-of select="/*/x:cgi/x:essid"/>
      </xsl:variable>
      <xsl:variable name="new-psk">
	<xsl:value-of select="/*/x:cgi/x:psk"/>
      </xsl:variable>
      <xsl:if test="string-length($new-essid) and string-length($new-psk)">
	<wifi>
	  <essid><xsl:value-of select="$new-essid"/></essid>
	  <psk><xsl:value-of select="$new-psk"/></psk>
	</wifi>
	<xsl:text>&#xa;</xsl:text>
      </xsl:if>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="x:wifi">
    <xsl:variable name="del" select="/*/x:cgi/x:*[local-name() = concat('delete-', current()/x:essid)]"/>
<!--    <xsl:comment> DEL <xsl:value-of select="x:essid"/>? ''<xsl:value-of select="count($del)"/>''</xsl:comment> -->
    <xsl:if test="not(string-length($del))">
      <xsl:copy>
	<xsl:copy-of select="@*"/>
	<xsl:apply-templates/>
      </xsl:copy>
    </xsl:if>
  </xsl:template>
  
</xsl:stylesheet>
