<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns="http://ai-and-it.de/xmlns/2020/xc"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="/">
    <!-- update! -->
    <xsl:comment>Update!</xsl:comment>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="x:limits-update">
    <xsl:apply-templates select="descendant-or-self::x:limits"/>
  </xsl:template>

  <xsl:template match="*">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="x:limits">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates/>
      <xsl:variable name="new-lhead" select="/*/x:cgi/x:head"/>
      <xsl:variable name="new-lmin" select="/*/x:cgi/x:min"/>
      <xsl:variable name="new-lmax" select="/*/x:cgi/x:max"/>
      <xsl:variable name="new-lwmin" select="/*/x:cgi/x:wmin"/>
      <xsl:variable name="new-lwmax" select="/*/x:cgi/x:wmax"/>
      <xsl:if test="string-length($new-lhead) and string-length($new-lmin) and string-length($new-lmax)
		    and string-length($new-lwmin) and string-length($new-lwmax)">
	<limit>
	  <head><xsl:value-of select="$new-lhead"/></head>
	  <min><xsl:value-of select="$new-lmin"/></min>
	  <wmin><xsl:value-of select="$new-lwmin"/></wmin>
	  <wmax><xsl:value-of select="$new-lwmax"/></wmax>
	  <max><xsl:value-of select="$new-lmax"/></max>
	</limit>
	<xsl:text>&#xa;</xsl:text>
      </xsl:if>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="x:limit">
    <xsl:variable name="new-lhead" select="/*/x:cgi/x:head"/>
    <xsl:variable name="new-lmin" select="/*/x:cgi/x:min"/>
    <xsl:variable name="new-lmax" select="/*/x:cgi/x:max"/>
    <xsl:variable name="new-lwmin" select="/*/x:cgi/x:wmin"/>
    <xsl:variable name="new-lwmax" select="/*/x:cgi/x:wmax"/>
    <xsl:variable name="del" select="/*/x:cgi/x:*[local-name() = concat('delete-', current()/x:head)]"/>
    <xsl:variable name="lmin" select="/*/x:cgi/x:*[local-name() = concat('min-', current()/x:head)]"/>
    <xsl:variable name="lmax" select="/*/x:cgi/x:*[local-name() = concat('max-', current()/x:head)]"/>
    <xsl:variable name="lwmin" select="/*/x:cgi/x:*[local-name() = concat('wmin-', current()/x:head)]"/>
    <xsl:variable name="lwmax" select="/*/x:cgi/x:*[local-name() = concat('wmax-', current()/x:head)]"/>
<!--    <xsl:comment> DEL <xsl:value-of select="x:essid"/>? ''<xsl:value-of select="count($del)"/>''</xsl:comment> -->
    <xsl:if test="not(string-length($del))
		  and not(string-length($new-lhead) and $new-lhead = current()/x:head
                          and string-length($new-lmin) and string-length($new-lmax) and string-length($new-lwmin) and string-length($new-lwmax))">
      <xsl:copy>
	<xsl:copy-of select="@*"/>
	<xsl:apply-templates select="x:head"/>
	<xsl:choose>
	  <xsl:when test="string-length($lmin)">
	    <min><xsl:value-of select="$lmin"/></min>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:apply-templates select="x:min"/>
	  </xsl:otherwise>
	</xsl:choose>
	<xsl:choose>
	  <xsl:when test="string-length($lwmin)">
	    <wmin><xsl:value-of select="$lwmin"/></wmin>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:apply-templates select="x:wmin"/>
	  </xsl:otherwise>
	</xsl:choose>
	<xsl:choose>
	  <xsl:when test="string-length($lwmax)">
	    <wmax><xsl:value-of select="$lwmax"/></wmax>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:apply-templates select="x:wmax"/>
	  </xsl:otherwise>
	</xsl:choose>
	<xsl:choose>
	  <xsl:when test="string-length($lmax)">
	    <max><xsl:value-of select="$lmax"/></max>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:apply-templates select="x:max"/>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:copy>
    </xsl:if>
  </xsl:template>
  
</xsl:stylesheet>
