<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns="http://www.w3.org/1999/xhtml"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="text()"/>

  <xsl:template match="/">
    <div class="measurement-result-files">
      <div id="result-view">
	<div id="result-dispsels"></div>
	<div id="result-dispopts"></div>
	<div id="result-nmeas"></div>
	<div class="charts">
	  <table id="container_0" class="container_0"></table>
	  <div id="container_1" class="chart-container"></div>
	  <div id="container_2" class="chart-container"></div>
	  <div id="container_3" class="chart-container"></div>
	  <div id="container_4" class="chart-container"></div>
	  <div id="container_5" class="chart-container"></div>
	  <div id="container_6" class="chart-container"></div>
	  <div id="container_7" class="chart-container"></div>
	  <div id="container_8" class="chart-container"></div>
	  <div id="container_9" class="chart-container"></div>
	  <div id="container_3d" class="chart-container"></div>
	</div>
      </div>
      <div class="measurement-result-file-list">
	<xsl:apply-templates/>
      </div>
    </div>
  </xsl:template>

  <xsl:template match="finfo">
    <table class="collection">
      <thead>
	<tr>
	  <td colspan="5"><xsl:value-of select="count(item[not(starts-with(name, '.'))])"/>
	  <xsl:text> </xsl:text>
	  <span class="tlt">Items</span></td>
	</tr>
	<tr>
	  <!-- <td>
	    <input type="checkbox" name="selall"/>
	  </td> -->
	  <th class="tlt sort-col sort-descending" onclick="return xc.sortCol(event)">Name</th>
	  <th class="tlt sort-col" onclick="return xc.sortCol(event)">Size</th>
	  <th class="tlt sort-col" onclick="return xc.sortCol(event)">Date</th>
	  <th/>
	  <th/>
	</tr>
      </thead>
      <tbody>
	<xsl:apply-templates select="item[not(starts-with(name, '.'))]">
	  <xsl:sort select="name" order="descending" data-type="text"/>
	</xsl:apply-templates>
      </tbody>
    </table>
  </xsl:template>

  <xsl:template match="finfo/item">
    <tr>
<!--      <td>
	<input type="checkbox" name="sel{position()}"/>
      </td> -->
      <td><a href="javascript:meas.loadMeasurement('{path}')"><xsl:value-of select="name[. != '']|path"/></a></td>
      <td class="unit-value">
	<span class="value-with-unit" data-unit="B" data-targetunit="MB">
	  <span class="value"><xsl:value-of select="statdict/st_size"/></span>
	  <span class="unit">&#xa0;B</span>
	</span>
      </td>
      <td><span class="unixtm"><xsl:value-of select="statdict/st_mtime"/></span></td>
      <td><a class="xc-nocatch tlt" href="/main/get/{path}">Download</a></td>
      <td><a class="tlt" href="/main/delete?path={path}&amp;next_=/main/ajax_view%3Fpath=measurements.xml">Delete</a></td>
    </tr>
  </xsl:template>

  <xsl:template match="lsl">
    <div class="file-info">
      <xsl:apply-templates select="finfo"/>
    </div>
  </xsl:template>

</xsl:stylesheet>
