<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns="http://www.w3.org/1999/xhtml"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="text()"/>

  <xsl:template match="/">
    <div>
      <div class="xc-sl-view"
	     data-view-url="/main/get?path=files/xml/mainmenu.xml"
	     data-view-filter="xc.psHTMLC"
	     data-view-cache="1"
	     >
      </div>
      <h2 class="tlt">Latest Measurement Values</h2>
      <xsl:apply-templates select="//x:measurement/x:pid"/>
    </div>
  </xsl:template>

  <xsl:template match="x:pid">
    <div>
      <form name="latest-val-display-mode">
	<label for="comp3d-select"><span class="tlt">Display 3D values</span>: </label>
	<select id="comp3d-select" name="comp3d">
	  <option value="aggr" class="tlt">Aggregate</option>
	  <option value="sep" class="tlt">Separate</option>
	</select>
	<xsl:text> </xsl:text>
	<label for="precision-select"><span class="tlt">Nummer precision</span>: </label>
	<select id="precision-select" name="precision">
	  <option value="1">1</option>
	  <option value="2">2</option>
	  <option value="3" selected="selected">3</option>
	  <option value="4">4</option>
	  <option value="5">5</option>
	  <option value="7">7</option>
	  <option value="9">9</option>
	  <option value="12">12</option>
	  <option value="15">15</option>
	</select>
<!--	<xsl:text> </xsl:text>
	<label for="plot-check"><span class="tlt">Graphic 3D value display</span>: </label>
	<input type="checkbox" id="plot-check" name="plot"/> -->
	<xsl:text> </xsl:text>
	<label for="update-check"><span class="tlt">Update</span>: </label>
	<input type="checkbox" id="update-check" name="update" checked="checked"/>
      </form>
      <div>
	<div id="meas-headers"
	     class="xc-sl-poll value-headers" data-poll-url="/main/head?path={../x:file}&amp;n=1"
	     data-postprocess="meas.psMeasurementHeaders"
	     data-poll-interval="10000">
	</div>
	<div id="meas-values"
	     class="xc-sl-poll livevalues" data-poll-url="/main/get?path=um-latest.csv"
	     data-postprocess="meas.psLatestMeasurements"
	     data-poll-interval="200">
	</div>
	<div id="curmeas-plots">
	  <div style="width: 16em; height: 16em;" id="curmeas-plot-0"></div>
	  <div style="width: 16em; height: 16em;" id="curmeas-plot-1"></div>
	  <div style="width: 16em; height: 16em;" id="curmeas-plot-2"></div>
	  <div style="width: 16em; height: 16em;" id="curmeas-plot-3"></div>
	  <div style="width: 16em; height: 16em;" id="curmeas-plot-4"></div>
	</div>
      </div>

<!--
      <button onclick="main()">Start</button><br/>
      <canvas id="glcanvas" width="640" height="480"
	      onmousedown="glplot.canvasMouseDown(event)"
	      onmouseup  ="glplot.canvasMouseUp(event)"
	      onmousemove="glplot.canvasMouseMove(event)"
	      onclick="glplot.canvasClick(event)"
	      ondblclick="glplot.canvasDoubleClick(event)"
	      ></canvas>
-->

    </div>
  </xsl:template>
  
</xsl:stylesheet>
