<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns="http://www.w3.org/1999/xhtml"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="text()"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="x:measurement">
    <div class="measurement-result-files">
      <div class="xc-sl-view"
	     data-view-url="/main/get?path=files/xml/mainmenu.xml"
	     data-view-filter="xc.psHTMLC"
	     data-view-cache="1"
	     >
      </div>
      <h2 class="tlt">Measurement Live View</h2>
      <xsl:apply-templates select="x:file[1]"/>
    </div>
  </xsl:template>
  
  <xsl:template match="x:file">
    <div class="measurement-file">

      <div style="display: none" id="live-view"/>
      <div id="result-view">
	<div id="result-dispsels"></div>
	<div id="result-dispopts-container"
	     data-view-url="/main/ajax_view?path=measurement-graph-controls.xml"
	     data-view-filter="measurement-graph-controls-view-html.xsl"
	     data-view-target="result-dispopts-container-target"
	     data-view-onload="document.forms.displayMode.onchange()"
	     class="xc-sl-view">
	  <div id="result-dispopts-container-target"></div>
	</div>
	<div id="result-nmeas"></div>

      <div class="xc-sl-poll"
	   id="meas-ps-poll"
	   data-poll-url="/main/tail?path={.}&amp;n=500"
	   data-fname="{.}"
	   data-postprocess="meas.psLiveMeasurement"
	   data-poll-interval="1000"
	   >
      </div>

      <div id="live-chart-table" class="chart-table">
	<table id="container_0" class="container_0"></table>
	<div id="container_1" class="chart-container container_1"></div>
	<div id="container_2" class="chart-container container_2"></div>
	<div id="container_3" class="chart-container container_3"></div>
	<div id="container_4" class="chart-container container_3"></div>
	<div id="container_5" class="chart-container container_3"></div>
	<div id="container_6" class="chart-container"></div>
	<div id="container_7" class="chart-container"></div>
	<div id="container_8" class="chart-container"></div>
	<div id="container_9" class="chart-container"></div>
	<div id="container_3d" class="chart-container container_3d"></div>
      </div>
      </div>
    </div>
  </xsl:template>
  
</xsl:stylesheet>
