<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns="http://www.w3.org/1999/xhtml"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="text()"/>

  <xsl:template match="/">
    <div>
      <div class="xc-sl-view"
	   data-view-url="/main/get/files/xml/mainmenu.xml"
	   data-view-cache="1"
	   data-view-filter="xc.psHTMLC">
      </div>
      <h2 class="tlt">Settings</h2>
      <div class="xc-sl-view"
	   data-view-url="/main/get/files/xml/settings-submenu.xml"
	   data-view-cache="1"
	   data-view-filter="xc.psHTMLC">
      </div>
      <h2 class="tlt">Limits</h2>
      <p class="tlt">Configure warning and alarm limits for measurement values</p>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="x:limits">
    <div class="um-wifi-settings">
      <form action="javascript:meas.submitLimitSettings" method="post">
	<fieldset>
	  <legend class="tlt">Configure new limit</legend>
	  <span class="xc-sl-poll"
		data-poll-url="/main/get?path=um-header.csv"
		id="limits-selector"
		data-postprocess="meas.psLimitSelector"
		data-poll-method="post"
		data-poll-interval="100000">
	    <label for="limit-head" class="tlt">Value</label>
	    <input id="limit-head" type="text" name="head"/>
	  </span>
	  <xsl:text> </xsl:text>
	  <input class="tltv" type="submit" value="Save"/>
	  <br/>
	  <label for="limit-min">Minimum</label>
	  <input class="tlnv limit" id="limit-min" type="text" name="min"/>
	  <xsl:text> </xsl:text>
	  <label for="warn-min" class="tlt">Lower warning level</label>
	  <input class="tlnv limit" id="warn-min" type="text" name="wmin"/>
	  <xsl:text> </xsl:text>
	  <label for="warn-max" class="tlt">Upper warning level</label>
	  <input class="tlnv limit" id="warn-max" type="text" name="wmax"/>
	  <xsl:text> </xsl:text>
	  <label for="limit-max">Maximum</label>
	  <input class="tlnv limit" id="limit-max" type="text" name="max"/>
	</fieldset>

	<h2 class="tlt">Limit settings</h2>
	<div class="xc-sl-sort"
	     data-select=".lname">
	  <xsl:apply-templates select="x:limit"/>
	</div>

	<input type="hidden" name="path"/>
	<input type="hidden" name="data"/>
	<input type="hidden" name="next_" value="/main/ajax_view?path=limits.xml"/>
	<input type="hidden" name="csrfmiddlewaretoken"/>
	<input class="tltv" type="submit" value="Save"/>
      </form>
    </div>
<!--    <div>
      <a href="/main/view?path=settings.xml">Main Configuration</a> -
      <a href="/main/view?path=wifi-settings.xml">Configure WiFi</a> -
      <a href="/main/view?path=limits.xml">Configure Limits</a><br/>
      <a href="/main/home">Home</a>
    </div> -->
  </xsl:template>

  <xsl:template match="x:limit">
    <fieldset>
      <legend>
	<span class="tlt">Limits for</span>
	<xsl:text> </xsl:text>
	<span class="lname">
	  <xsl:choose>
	    <xsl:when test="contains(x:head, '_')">
	      <span class="tlt">
		<xsl:value-of select="substring-before(x:head, '_')"/>
	      </span>
	      <xsl:text> </xsl:text>
	      <xsl:value-of select="substring-after(x:head, '_')"/>
	    </xsl:when>
	    <xsl:otherwise>
	      <span class="tlt">
		<xsl:value-of select="x:head"/>
	      </span>
	    </xsl:otherwise>
	  </xsl:choose>
	</span>
      </legend>
      <label for="limit-min-{generate-id()}">Minimum</label>
      <input class="tlnv limit" id="limit-min-{generate-id()}" type="text" value="{x:min}" name="min-{x:head}"/>
      <xsl:text> </xsl:text>
      <label for="warn-min-{generate-id()}" class="tlt">Lower warning level</label>
      <input class="tlnv limit" id="warn-min-{generate-id()}" type="text" value="{x:wmin}" name="wmin-{x:head}"/>
      <xsl:text> </xsl:text>
      <label for="warn-max-{generate-id()}" class="tlt">Upper warning level</label>
      <input class="tlnv limit" id="warn-max-{generate-id()}" type="text" value="{x:wmax}" name="wmax-{x:head}"/>
      <xsl:text> </xsl:text>
      <label for="limit-max-{generate-id()}">Maximum</label>
      <input class="tlnv limit" id="limit-max-{generate-id()}" type="text" value="{x:max}" name="max-{x:head}"/>
      <xsl:text> </xsl:text>
      <label for="limit-delete-{generate-id()}" class="tlt">Delete</label>
      <input id="limit-delete-{generate-id()}" type="checkbox" name="delete-{x:head}"/>
    </fieldset>
  </xsl:template>
  
</xsl:stylesheet>
