#! /bin/bash

set -x

mydir=$(readlink -f $(dirname $BASH_SOURCE))

export XC_WORKDIR=$(readlink -f $mydir/..)

# Config variables
program=icm20640-fifo-mp

# Config from file
source $mydir/../etc/sensorsettings.conf

if [[ -z "$program" ]]; then
    program=icm20640-fifo-mp
fi

umprog=$program

pidfile=$XC_WORKDIR/measurement.pid

logfname=measurement.log
logfile=$XC_WORKDIR/$logfname

exec > $logfile
exec 2>&1

if [[ -f "$pidfile" ]]; then

    pid=$(cat "$pidfile")

    if ps -p $pid -F | grep python3 > /dev/null 2>&1; then
	echo "Error: PID file exists, and a measurement is running:"
	ps -p $pid -o command | tail -n 1
	exit 0
    else
	rm $pidfile
	echo "Stale PID file deleted"
    fi

fi

measdir=measurements
measdir_full=$XC_WORKDIR/$measdir
mkdir -p $measdir_full

dstr=$(date +"%Y-%m-%dT%H%M%S")
ofname=$measdir/measurement-${dstr}.csv
ofnames=$measdir/measurement-${dstr}-slow.csv

ofname_full=$XC_WORKDIR/$ofname
ofnames_full=$XC_WORKDIR/$ofnames

echo "PWD: $PWD"

$umprog -c $XC_WORKDIR/etc/sensorsettings.ini --outfile=$ofname --downsample-outfile=$ofnames >> $logfile 2>&1 &
rpid=$!

ln -sfT measurement-${dstr}.csv $measdir/latest.csv
ln -sfT measurement-${dstr}-slow.csv $measdir/latest-slow.csv

echo "Start measurement process $rpid"

echo "$rpid" > $pidfile

echo "<measurement xmlns='http://ai-and-it.de/xmlns/2020/xc'><log>$logfname</log><pid>$rpid</pid><file>$ofname</file><file>$ofnames</file></measurement>" > $mydir/../measurement.xml

exit 0
