<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns="http://ai-and-it.de/xmlns/2020/xc"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="x:settings-update">
    <xsl:apply-templates select="descendant-or-self::x:settings"/>
  </xsl:template>

  <xsl:template match="*">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="x:measurement-program/x:alternatives/x:current">
    <current>
      <xsl:value-of select="/*/x:cgi/x:main-prog"/>
    </current>
  </xsl:template>

  <xsl:template match="x:interval/x:value">
    <value>
      <xsl:value-of select="/*/x:cgi/x:interval"/>
    </value>
  </xsl:template>

  <xsl:template match="x:block-size/x:value">
    <value>
      <xsl:value-of select="/*/x:cgi/x:blocksz"/>
    </value>
  </xsl:template>

  <xsl:template match="*" name="check-to-num" mode="check-to-num">
    <xsl:param name="str" select="."/>
    <xsl:choose>
      <xsl:when test="string-length($str)>0">1</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="x:sample-rate/x:value">
    <value>
      <xsl:value-of select="/*/x:cgi/x:settings-sample-rate"/>
    </value>
  </xsl:template>

  <xsl:template match="x:sensors/x:mag/x:value">
    <value>
      <xsl:call-template name="check-to-num">
	<xsl:with-param name="str" select="/*/x:cgi/x:mag"/>
      </xsl:call-template>
    </value>
  </xsl:template>

  <xsl:template match="x:sensors/x:accel/x:value">
    <xsl:copy>
      <xsl:call-template name="check-to-num">
	<xsl:with-param name="str" select="/*/x:cgi/x:accel"/>
      </xsl:call-template>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="x:sensors/x:accel/x:filter/x:enable">
    <xsl:copy>
      <xsl:call-template name="check-to-num">
	<xsl:with-param name="str" select="/*/x:cgi/x:accel-filter"/>
      </xsl:call-template>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="x:sensors/x:accel/x:filter/x:bandwidth/x:value">
    <value>
      <xsl:value-of select="/*/x:cgi/x:accel-bandwidth"/>
    </value>
  </xsl:template>

  <xsl:template match="x:sensors/x:accel/x:range/x:value">
    <value>
      <xsl:value-of select="/*/x:cgi/x:accel-range"/>
    </value>
  </xsl:template>

  <xsl:template match="x:sensors/x:accel/x:unit/x:value">
    <value>
      <xsl:value-of select="/*/x:cgi/x:accel-unit"/>
    </value>
  </xsl:template>


  <xsl:template match="x:sensors/x:gyro/x:value">
    <value>
      <xsl:call-template name="check-to-num">
	<xsl:with-param name="str" select="/*/x:cgi/x:gyro"/>
      </xsl:call-template>
    </value>
  </xsl:template>

  <xsl:template match="x:sensors/x:gyro/x:filter/x:enable">
    <xsl:copy>
      <xsl:call-template name="check-to-num">
	<xsl:with-param name="str" select="/*/x:cgi/x:gyro-filter"/>
      </xsl:call-template>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="x:sensors/x:gyro/x:filter/x:bandwidth/x:value">
    <xsl:copy>
      <xsl:value-of select="/*/x:cgi/x:gyro-bandwidth"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="x:sensors/x:gyro/x:range/x:value">
    <xsl:copy>
      <xsl:value-of select="/*/x:cgi/x:gyro-range"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="x:sensors/x:temp/x:value">
    <value>
      <xsl:call-template name="check-to-num">
	<xsl:with-param name="str" select="/*/x:cgi/x:*[local-name() = concat('temp', current()/../@index)]"/>
      </xsl:call-template>
    </value>
  </xsl:template>

</xsl:stylesheet>
