<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  version="1.0">

  <xsl:output method="text" encoding="utf-8"/>

  <xsl:template match="/">
    <xsl:text>

[icmsensor]

# device address
dev = 1

# CSV value formatting
# style
# format = e
# precision
# precision = 10

# emit raw 16 bit sensor values
# raw_values = 0


# Gyro values via FIFO
# fifo_gyro = 1

# Gyro correction
# 0: off, 1: device values, 2: from JSON file &lt;gyro_correction_file>
# gyro_corr = 2

# Gyro correction JSON file
# gyro_correction_file = 'calibg.json'

# Gyro disable
# gyro_disable = 0

# Gyro frequency
# gyro_freq = 1125

# Gyro scale
# gyro_scale = 500

# Gyro use filter
# gyro_use_filter = 1

# Gyro averaging
# gyro_avg = 1

# Gyro filter bandwidth (Hz)
# gyro_filter_bw = 375


# Accel values via FIFO
# fifo_accel = 1

# Accel disable
# accel_disable = 0

# Accel correction
# accel_corr = 1

# Accel X factor
# accelx_factor = 1

# Accel Y factor
# accely_factor = 1

# Accel Z factor
# accelz_factor = -1

# Accel frequency
# accel_freq = 1125

# Accel scale
# accel_scale = 30

# Accel use filter
# accel_use_filter = 1

# Accel filter bandwidth (Hz)
# accel_filter_bw = 500

# Accel averaging
# accel_avg = 4

# disable temperatures
# temp_disable = 0
# temperatures via FIFO
# fifo_temp = 0
# frequency of temperature readings (Hz)
# temp_freq = 100

# temp sensor channels enabled
# temp_ext_enable = 0,1

# emit relative time stamps (starting from 0)
# rel_times = 0

# mode of outfile
# output = ilff

# name of outfile
# outfile = out2.csv

# downsampled output rate (50 Hz)
# downsample_rate = 50

# downsampled output file (default: &lt;outfile>-&lt;downsample_rate>Hz.csv)
# downsample_outfile = out-slow.csv

</xsl:text>

    <xsl:apply-templates select="x:settings"/>

    <xsl:text>accelz_factor = -1</xsl:text>
    <xsl:text>&#xa;</xsl:text>

  </xsl:template>

  <xsl:template match="text()"/>

  <xsl:template match="x:measurement-program/x:alternatives/x:current">
    <xsl:text>main = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>


  <xsl:template match="x:sample-rate/x:value">
    <xsl:text>accel_freq = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
    <xsl:text>gyro_freq = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>


  <xsl:template match="x:sensors/x:accel/x:value">
    <xsl:text>accel_disable = </xsl:text>
    <xsl:choose>
      <xsl:when test=". = 0">1</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="x:sensors/x:accel/x:filter/x:enable">
    <xsl:text>accel_use_filter = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="x:sensors/x:accel/x:filter/x:bandwidth/x:value">
    <xsl:text>accel_filter_bw = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="x:sensors/x:accel/x:range/x:value">
    <xsl:text>accel_scale = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="x:sensors/x:accel/x:unit/x:value">
    <xsl:text>accel_g = </xsl:text>
    <xsl:choose>
      <xsl:when test=". = 'g'">1</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>


  <xsl:template match="x:sensors/x:gyro/x:value">
    <xsl:text>gyro_disable = </xsl:text>
    <xsl:choose>
      <xsl:when test=". = 0">1</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="x:sensors/x:gyro/x:filter/x:enable">
    <xsl:text>gyro_use_filter = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="x:sensors/x:gyro/x:filter/x:bandwidth/x:value">
    <xsl:text>gyro_filter_bw = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="x:sensors/x:gyro/x:range/x:value">
    <xsl:text>gyro_scale = </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="x:sensors/x:temp[1]">
    <xsl:text>temp_ext_enable = </xsl:text>
    <xsl:for-each select="../x:temp[x:value = 1]">
      <xsl:if test="position()>1">,</xsl:if>
      <xsl:value-of select="@index"/>
    </xsl:for-each>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

</xsl:stylesheet>
