<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns="http://ai-and-it.de/xmlns/2020/xc"
  version="1.0">

  <xsl:output method="text" encoding="utf-8"/>

  <xsl:template match="text()"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="x:min|x:wmin|x:max|x:wmax">
    <xsl:text>"</xsl:text>
    <xsl:value-of select="local-name()"/>
    <xsl:text>":</xsl:text>
    <xsl:choose>
      <xsl:when test="number(.) >= 0 or number(.) &lt;= 0">
	<xsl:value-of select="number(.)"/>
      </xsl:when>
      <xsl:otherwise>"<xsl:value-of select="."/>"</xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="x:limits">
    {
    <xsl:for-each select="x:limit">
      <xsl:if test="position()>1">
	<xsl:text>,</xsl:text>
      </xsl:if>
      "<xsl:value-of select="x:head"/>": {
      <xsl:apply-templates select="x:min"/>, <xsl:apply-templates select="x:wmin"/>, <xsl:apply-templates
         select="x:wmax"/>, <xsl:apply-templates select="x:max"/> }
    </xsl:for-each>
    }
  </xsl:template>

</xsl:stylesheet>
