<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:x="http://ai-and-it.de/xmlns/2020/xc"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns="http://www.w3.org/1999/xhtml"
  version="1.0">

  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="text()"/>

  <xsl:template match="/">
    <div>
      <div class="xc-sl-view"
	   data-view-url="/main/get/files/xml/mainmenu.xml"
	   data-view-cache="1"
	   data-view-filter="xc.psHTMLC">
      </div>
      <h2 class="tlt">Settings</h2>
      <div class="xc-sl-view"
	   data-view-url="/main/get/files/xml/settings-submenu.xml"
	   data-view-cache="1"
	   data-view-filter="xc.psHTMLC">
      </div>
      <h2 class="tlt">Measurement Settings</h2>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="x:settings">
    <div class="um-settings">
      <form action="javascript:meas.submitSettings" method="post">
	<xsl:apply-templates/>
<!--	<fieldset>
	  <legend>WiFi Settings</legend>
	  <label for="wifi-essid">WiFi Name (ESSID)</label>
	  <input id="wifi-essid" type="text" name="essid"/>
	  <label for="wifi-psk">WiFi Password (PSK)</label>
	  <input id="wifi-psk" type="text" name="psk"/>
	</fieldset> -->
	<input type="hidden" name="path" value="settings.xml"/>
	<input type="hidden" name="data"/>
	<input type="hidden" name="next_" value="/main/ajax_view?path=settings.xml"/>
	<input type="hidden" name="csrfmiddlewaretoken"/>
	<input class="tltv" type="submit" value="Save"/>
      </form>
    </div>
<!--    <div>
      <a href="/main/view?path=settings.xml">Main Configuration</a> -
      <a href="/main/view?path=wifi-settings.xml">Configure WiFi</a> -
      <a href="/main/view?path=limits.xml">Configure Limits</a><br/>
      <a href="/main/home">Home</a>
    </div> -->
  </xsl:template>

  <xsl:template match="x:measurement-program"/>
  <xsl:template match="x:measurement-program" mode="xx">
    <fieldset>
      <legend class="tlt">Measurement program</legend>
      <select name="main-prog">
	<xsl:for-each select="x:alternatives/x:alternative">
	  <option value="{x:name}" class="tlto">
	    <xsl:if test="x:name = ../x:current">
	      <xsl:attribute name="selected">selected</xsl:attribute>
	    </xsl:if>
	    <xsl:value-of select="x:name"/>
	    <xsl:text> - </xsl:text>
	    <xsl:value-of select="x:description"/>
	  </option>
	</xsl:for-each>
      </select>
    </fieldset>
  </xsl:template>

  <xsl:template match="x:interval">
<!--    <fieldset>
      <legend class="tlt">Measurement interval</legend>
      <div class="xc-slider">
	<label for="interval" class="tlt">Measurement interval in seconds</label>
	<input id="interval" name="interval" type="range"
	       min="{x:min}" max="{x:max}" value="{x:value}"/>
	<input id="interval-disp" type="text" value="{x:value}"/>
	<label for="interval-disp">s</label>
      </div>
    </fieldset> -->
  </xsl:template>

<!--  <xsl:template match="x:block-size">
    <fieldset>
      <legend class="tlt">Block size</legend>
      <div class="xc-slider">
	<label for="blocksz" class="tlt">Block size in number of lines</label>
	<input id="blocksz" name="blocksz" type="range"
	       min="{x:min}" max="{x:max}" value="{x:value}"/>
	<input id="blocksz-disp" type="text" value="{x:value}"/>
	<label for="blocksz-disp">s</label>
      </div>
    </fieldset>
  </xsl:template> -->

  <xsl:template match="x:mag" mode="sel-sensor-name"><span class="tlt">Magnetometer</span></xsl:template>
  <xsl:template match="x:accel" mode="sel-sensor-name"><span class="tlt">Accelerometer</span></xsl:template>
  <xsl:template match="x:gyro" mode="sel-sensor-name"><span class="tlt">Gyroscope</span></xsl:template>
  <xsl:template match="x:temp" mode="sel-sensor-name">
    <span class="tlt">Temperature</span>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@index + 1"/>
  </xsl:template>
  <xsl:template match="x:gashook" mode="sel-sensor-name"><span class="tlt">Gas and particles sensor</span></xsl:template>

  <xsl:template match="x:sensors">
    <fieldset>
      <legend class="tlt">Sensors</legend>
      <div class="xc-checks">
	<xsl:for-each select="x:*">
	  <div>
	    <input id="{local-name()}{@index}" name="{local-name()}{@index}" type="checkbox">
	      <xsl:if test="x:value>0">
		<xsl:attribute name="checked">checked</xsl:attribute>
	      </xsl:if>
	    </input>
	    <label for="{local-name()}{@index}"><xsl:apply-templates select="." mode="sel-sensor-name"/></label>
	  </div>
	</xsl:for-each>
      </div>
      <div class="sample-rate">
	<xsl:apply-templates select="../x:sample-rate" mode="select-value"/>
      </div>
    </fieldset>

    <fieldset>
      <legend class="tlt">Accelerometer</legend>
      <xsl:apply-templates select="x:accel/x:filter" mode="enable-value"/>
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="x:accel/x:filter/x:bandwidth" mode="select-value">
	<xsl:with-param name="name">accel-bandwidth</xsl:with-param>
	<xsl:with-param name="disabled" select="x:accel/x:filter/x:enable"/>
      </xsl:apply-templates>
      <br/>
      <xsl:apply-templates select="x:accel/x:range" mode="select-value"/>
      <xsl:apply-templates select="x:accel/x:unit" mode="select-value"/>
    </fieldset>

    <fieldset>
      <legend class="tlt">Gyroscope</legend>
      <xsl:apply-templates select="x:gyro/x:filter" mode="enable-value"/>
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="x:gyro/x:filter/x:bandwidth" mode="select-value">
	<xsl:with-param name="name">gyro-bandwidth</xsl:with-param>
	<xsl:with-param name="disabled" select="x:accel/x:filter/x:enable"/>
      </xsl:apply-templates>
      <br/>
      <xsl:apply-templates select="x:gyro/x:range" mode="select-value"/>
    </fieldset>

  </xsl:template>


  <xsl:template match="x:*" mode="prop-name">
    <xsl:value-of select="local-name()"/>
  </xsl:template>
  <xsl:template match="x:sample-rate" mode="prop-name">Sample rate</xsl:template>
  <xsl:template match="x:range" mode="prop-name">Measurement range</xsl:template>
  <xsl:template match="x:filter" mode="prop-name">Filter</xsl:template>
  <xsl:template match="x:bandwidth" mode="prop-name">Band width</xsl:template>
  <xsl:template match="x:unit" mode="prop-name">Unit</xsl:template>
  <xsl:template match="x:correction" mode="prop-name">Correction</xsl:template>

  <xsl:template match="x:*" mode="enable-value">
    <xsl:param name="title">
      <span class="tlt">
	<xsl:apply-templates select="." mode="prop-name"/>
      </span>
    </xsl:param>
    <xsl:param name="name" select="concat(local-name(..), '-', local-name())"/>
    <xsl:variable name="this" select="."/>
    <label for="{local-name()}"><xsl:copy-of select="$title"/></label>
    <input id="{$name}" name="{$name}" type="checkbox" onchange="meas.onChangeSettings(this, event)">
      <xsl:if test="x:enable>0">
	<xsl:attribute name="checked">checked</xsl:attribute>
      </xsl:if>
    </input>
  </xsl:template>

  <xsl:template match="x:*" mode="select-value">
    <xsl:param name="name" select="concat(local-name(..), '-', local-name())"/>
    <xsl:param name="disabled"/>
    <xsl:variable name="this" select="."/>
    <label for="{$name}">
      <span class="tlt">
	<xsl:apply-templates select="." mode="prop-name"/>
      </span>
    </label>
    <select id="{$name}" name="{$name}" onchange="meas.onChangeSettings(this, event)">
      <xsl:if test="$disabled">
	<xsl:attribute name="disabled">disabled</xsl:attribute>
      </xsl:if>
      <xsl:for-each select="x:available/x:value">
	<option value="{.}">
	  <xsl:if test=". = ../../x:value">
	    <xsl:attribute name="selected">selected</xsl:attribute>
	  </xsl:if>
	  <xsl:value-of select="."/>
	  <xsl:text> </xsl:text>
	  <xsl:value-of select="$this/@unit"/>
	</option>
      </xsl:for-each>
    </select>
  </xsl:template>

</xsl:stylesheet>
