#! /bin/bash

set -x

HOST=${HOST:-$(hostname)}

UMW_HOSTNAME=${UMW_HOSTNAME:-$HOST}
UMW_HOSTNAME_GENERIC=${UMW_HOSTNAME_GENERIC:-umweltmodul}
UMW_DOMAIN=${UMW_DOMAIN:-umw}

export UMW_DOMAIN UMW_HOSTNAME UMW_HOSTNAME_GENERIC

XC_WORKDIR='/var/lib/xc/usense'

XC_HOME=${XC_HOME:-/var/lib/ai-and-it/xc}

# cd $XC_HOME/xc && python3 setup-xc.py

mkdir -p $XC_WORKDIR/measurements
mkdir -p $XC_WORKDIR/events
mkdir -p $XC_WORKDIR/etc

cd $XC_WORKDIR/ && ln -sfT $XC_HOME/xc/login/static sys

echo "$XC_HOME/" > /etc/xc/allowed-paths.txt
echo "/run/usense" >> /etc/xc/allowed-paths.txt

sed -i.bak -e "s;xc_appdir *=.*;xc_appdir = '$XC_WORKDIR';" $XC_HOME/xc/xc/settings.py
sed -i.bak -e "s;XC_HOME_PATH *=.*;XC_HOME_PATH = 'measurement.xml';" $XC_HOME/xc/xc/settings.py
sed -i.bak -e "/'DIRS'/ c         'DIRS': [ '/var/lib/xc/usense/templates' ]," $XC_HOME/xc/xc/settings.py
sed -i.bak -e "s;MAIN_FRAME *=.*;MAIN_FRAME = 'xframe-main.html';" $XC_HOME/xc/xc/settings.py
if ! grep XC_DIRMAN $XC_HOME/xc/xc/settings.py > /dev/null; then
    sed -i.bak -e "/XC_USE_GIT/ a XC_DIRMAN = 'usensedirman'" $XC_HOME/xc/xc/settings.py
fi

if ! grep disable-logging /etc/uwsgi-emperor/vassals/xc_uwsgi.ini; then
    echo "disable-logging = true" >> /etc/uwsgi-emperor/vassals/xc_uwsgi.ini
fi

runUser=www-data
ruuid=$(id -u $runUser)

chown -R $runUser $XC_WORKDIR

adduser $runUser spi
adduser $runUser i2c
adduser $runUser gpio
adduser $runUser netdev

cp -v $XC_WORKDIR/files/ci/sudo-www-data.conf /etc/sudoers.d/010_www-data
chmod 440 /etc/sudoers.d/010_www-data

$XC_WORKDIR/files/ci/config-run-usense-dir.sh

runUserHome=$(sudo -u $runUser bash -c 'cd; pwd')

sudo chown root:$runUser $runUserHome
sudo chmod g+w           $runUserHome

sudo -u $runUser git config --global user.name "uSense"
sudo -u $runUser git config --global user.email "info@fionec.com"

# for AD (temperature) chip
if false; then
    sudo python3 -m pip install adafruit-circuitpython-ccs811
    sudo apt-get install -y build-essential python-pip python-dev python-smbus git xrdp
    cd /tmp
    git clone https://github.com/adafruit/Adafruit_Python_GPIO.git
    cd Adafruit_Python_GPIO
    sudo python3 setup.py install
    sudo python3 -m pip install Adafruit_CCS811
    # examples
    # git clone https://github.com/adafruit/Adafruit_CCS811_python.git
fi

# for ILFF python package (now has debian package)
#sudo python3 -m pip config --global set global.extra-index-url http://fnc-jenkins:9000/
#sudo python3 -m pip config --global set global.trusted-host fnc-jenkins
#sudo python3 -m pip install --no-cache-dir -I ilff

if ! grep "dtparam=i2c_baudrate" /boot/config.txt; then
    echo "dtparam=i2c_baudrate=10000" >> /boot/config.txt
fi

# for access point
if false; then
    cd $XC_WORKDIR/../raspi-ap && ./config-ap.sh
fi

cd $XC_WORKDIR
./files/ci/setup-email-config.sh

function runxslt {
    xsltproc -o $3 $1 $2
    res=$?
    if [[ "$res" != "0" ]]; then
	echo "XSLT failed: xsltproc -o $3 $1 $2"
	exit 1
    fi
}

runxslt files/xsl/update-settings-ini.xsl settings.xml etc/sensorsettings.ini
runxslt files/xsl/update-settings-conf.xsl settings.xml etc/sensorsettings.conf

runxslt files/xsl/update-limits-conf.xsl limits.xml etc/limits.json
runxslt files/xsl/update-limits-conf.xsl limits.xml etc/default-limits.json

runxslt files/xsl/update-wifi-settings-conf.xsl wifi-settings.xml etc/wpa_supplicant.conf

chown -R $runUser $XC_WORKDIR
chgrp pi -R /var/lib/xc
chmod g+w -R /var/lib/xc

cd $XC_WORKDIR

if ! grep logto /etc/uwsgi-emperor/emperor.ini; then
    cat >> /etc/uwsgi-emperor/emperor.ini <<'EOF'

logto = /var/log/uwsgi/emperor.log

EOF
fi

systemctl restart uwsgi-emperor
touch /etc/uwsgi-emperor/vassals/xc_uwsgi.ini
