#! /usr/bin/env python3

import sys
import re

def parse(inf):
    print('Package; Version; Status')
    while True:
        ln = inf.readline()
        if len(ln) == 0:
            break

        ln = ln.rstrip()
        fields = ln.split(' ')

        if len(fields) < 2:
            continue
        
        status = re.search(r'\[(.*)\]', ln)
        if status:
            status = status.group(1)
        else:
            status = ''
        
        fields[0:1] = fields[0].split('/')
#        fields[1] = fields[1].split(',')
        fields[4:] = (status,)
        del fields[3]
        del fields[1]
        print(';'.join(fields))

if __name__ == "__main__":
    parse(sys.stdin)
